/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.service;

import de.adorsys.aspsp.xs2a.config.ProfileConfiguration;
import de.adorsys.aspsp.xs2a.domain.BookingStatus;
import de.adorsys.aspsp.xs2a.domain.MulticurrencyAccountLevel;
import de.adorsys.aspsp.xs2a.domain.ScaApproach;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileService {
    private final ProfileConfiguration profileConfiguration;

    public int getFrequencyPerDay() {
        return this.profileConfiguration.getFrequencyPerDay();
    }

    public void updateFrequencyPerDay(int frequencyPerDay) {
        this.profileConfiguration.setFrequencyPerDay(frequencyPerDay);
    }

    public boolean isCombinedServiceIndicator() {
        return this.profileConfiguration.isCombinedServiceIndicator();
    }

    public void updateCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.profileConfiguration.setCombinedServiceIndicator(combinedServiceIndicator);
    }

    public List<String> getAvailablePaymentProducts() {
        return this.profileConfiguration.getAvailablePaymentProducts();
    }

    public void updateAvailablePaymentProducts(List<String> availablePaymentProducts) {
        this.profileConfiguration.setAvailablePaymentProducts(availablePaymentProducts);
    }

    public List<String> getAvailablePaymentTypes() {
        return this.profileConfiguration.getAvailablePaymentTypes();
    }

    public void updateAvailablePaymentTypes(List<String> availablePaymentTypes) {
        this.profileConfiguration.setAvailablePaymentTypes(availablePaymentTypes);
    }

    public ScaApproach getScaApproach() {
        return this.profileConfiguration.getScaApproach();
    }

    public void updateScaApproach(ScaApproach scaApproach) {
        this.profileConfiguration.setScaApproach(scaApproach);
    }

    public boolean isTppSignatureRequired() {
        return this.profileConfiguration.isTppSignatureRequired();
    }

    public void updateTppSignatureRequired(boolean tppSignatureRequired) {
        this.profileConfiguration.setTppSignatureRequired(tppSignatureRequired);
    }

    public String getPisRedirectUrlToAspsp() {
        return this.profileConfiguration.getPisRedirectUrlToAspsp();
    }

    public void updatePisRedirectUrlToAspsp(String redirectUrlToAspsp) {
        this.profileConfiguration.setPisRedirectUrlToAspsp(redirectUrlToAspsp);
    }

    public String getAisRedirectUrlToAspsp() {
        return this.profileConfiguration.getAisRedirectUrlToAspsp();
    }

    public void updateAisRedirectUrlToAspsp(String redirectUrlToAspsp) {
        this.profileConfiguration.setAisRedirectUrlToAspsp(redirectUrlToAspsp);
    }

    public MulticurrencyAccountLevel getMulticurrencyAccountLevel() {
        return this.profileConfiguration.getMulticurrencyAccountLevel();
    }

    public void updateMulticurrencyAccountLevel(MulticurrencyAccountLevel multicurrencyAccountLevel) {
        this.profileConfiguration.setMulticurrencyAccountLevel(multicurrencyAccountLevel);
    }

    public List<BookingStatus> getAvailableBookingStatuses() {
        return this.profileConfiguration.getAvailableBookingStatuses();
    }

    public void updateAvailableBookingStatuses(List<BookingStatus> availableBookingStatuses) {
        if (!availableBookingStatuses.contains(BookingStatus.BOOKED)) {
            availableBookingStatuses.add(BookingStatus.BOOKED);
        }
        this.profileConfiguration.setAvailableBookingStatuses(availableBookingStatuses);
    }

    @ConstructorProperties(value={"profileConfiguration"})
    public AspspProfileService(ProfileConfiguration profileConfiguration) {
        this.profileConfiguration = profileConfiguration;
    }
}

