/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.web;

import de.adorsys.aspsp.xs2a.domain.ScaApproach;
import de.adorsys.aspsp.xs2a.service.AspspProfileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"aspsp-profile"})
@Api(value="Aspsp profile", tags={"Aspsp profile"}, description="Provides access to aspsp profile", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
public class AspspProfileController {
    private final AspspProfileService aspspProfileService;

    @GetMapping(path={"/frequency-per-day"})
    @ApiOperation(value="Reads frequency per day")
    @ApiResponse(code=200, message="Ok", response=String.class)
    public ResponseEntity<Integer> getFrequencyPerDay() {
        return new ResponseEntity((Object)this.aspspProfileService.getFrequencyPerDay(), HttpStatus.OK);
    }

    @GetMapping(path={"/combined-service-indicator"})
    @ApiOperation(value="Reads combined service indicator value")
    @ApiResponse(code=200, message="Ok", response=String.class)
    public ResponseEntity<Boolean> getCombinedServiceIndicator() {
        return new ResponseEntity((Object)this.aspspProfileService.isCombinedServiceIndicator(), HttpStatus.OK);
    }

    @GetMapping(path={"/available-payment-products"})
    @ApiOperation(value="Reads list of available payment products")
    @ApiResponse(code=200, message="Ok", response=String.class)
    public ResponseEntity<List<String>> getAvailablePaymentProducts() {
        return new ResponseEntity((Object)this.aspspProfileService.getAvailablePaymentProducts(), HttpStatus.OK);
    }

    @GetMapping(path={"/available-payment-types"})
    @ApiOperation(value="Reads list of available payment types ")
    @ApiResponse(code=200, message="Ok", response=String.class)
    public ResponseEntity<List<String>> getAvailablePaymentTypes() {
        return new ResponseEntity((Object)this.aspspProfileService.getAvailablePaymentTypes(), HttpStatus.OK);
    }

    @GetMapping(path={"/sca-approach"})
    @ApiOperation(value="Reads sca approach value")
    @ApiResponse(code=200, message="Ok", response=ScaApproach.class)
    public ResponseEntity<ScaApproach> getScaApproach() {
        return new ResponseEntity((Object)this.aspspProfileService.getScaApproach(), HttpStatus.OK);
    }

    @GetMapping(path={"/tpp-signature-required"})
    @ApiOperation(value="Reads signature of the request by the TPP")
    @ApiResponse(code=200, message="Ok", response=String.class)
    public ResponseEntity<Boolean> getTppSignatureRequired() {
        return new ResponseEntity((Object)this.aspspProfileService.isTppSignatureRequired(), HttpStatus.OK);
    }

    @GetMapping(path={"/redirect-url-to-aspsp-pis"})
    @ApiOperation(value="Reads Pis redirect url to aspsp")
    @ApiResponse(code=200, message="Ok", response=String.class)
    public ResponseEntity<String> getPisRedirectUrlToAspsp() {
        return new ResponseEntity((Object)this.aspspProfileService.getPisRedirectUrlToAspsp(), HttpStatus.OK);
    }

    @GetMapping(path={"/redirect-url-to-aspsp-ais"})
    @ApiOperation(value="Reads Ais redirect url to aspsp")
    @ApiResponse(code=200, message="Ok", response=String.class)
    public ResponseEntity<String> getAisRedirectUrlToAspsp() {
        return new ResponseEntity((Object)this.aspspProfileService.getAisRedirectUrlToAspsp(), HttpStatus.OK);
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public AspspProfileController(AspspProfileService aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

