/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.config;

import de.adorsys.aspsp.xs2a.domain.PaymentType;
import de.adorsys.aspsp.xs2a.domain.ScaApproach;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:bank_profile.yml"})
@ConfigurationProperties(prefix="setting")
public class ProfileConfiguration {
    private static final boolean isDelayedPaymentTypeAllowedAlways = true;
    private int frequencyPerDay;
    private boolean combinedServiceIndicator;
    private List<String> availablePaymentProducts;
    private List<String> availablePaymentTypes;
    private ScaApproach scaApproach;
    private boolean tppSignatureRequired;
    private String pisRedirectUrlToAspsp;
    private String aisRedirectUrlToAspsp;

    @PostConstruct
    private void addNecessaryPaymentTypesByDefault() {
        String necessaryType = PaymentType.FUTURE_DATED.getValue();
        if (!this.availablePaymentTypes.contains(necessaryType)) {
            this.availablePaymentTypes.add(PaymentType.FUTURE_DATED.getValue());
        }
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public List<String> getAvailablePaymentProducts() {
        return this.availablePaymentProducts;
    }

    public List<String> getAvailablePaymentTypes() {
        return this.availablePaymentTypes;
    }

    public ScaApproach getScaApproach() {
        return this.scaApproach;
    }

    public boolean isTppSignatureRequired() {
        return this.tppSignatureRequired;
    }

    public String getPisRedirectUrlToAspsp() {
        return this.pisRedirectUrlToAspsp;
    }

    public String getAisRedirectUrlToAspsp() {
        return this.aisRedirectUrlToAspsp;
    }

    public void setFrequencyPerDay(int frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public void setAvailablePaymentProducts(List<String> availablePaymentProducts) {
        this.availablePaymentProducts = availablePaymentProducts;
    }

    public void setAvailablePaymentTypes(List<String> availablePaymentTypes) {
        this.availablePaymentTypes = availablePaymentTypes;
    }

    public void setScaApproach(ScaApproach scaApproach) {
        this.scaApproach = scaApproach;
    }

    public void setTppSignatureRequired(boolean tppSignatureRequired) {
        this.tppSignatureRequired = tppSignatureRequired;
    }

    public void setPisRedirectUrlToAspsp(String pisRedirectUrlToAspsp) {
        this.pisRedirectUrlToAspsp = pisRedirectUrlToAspsp;
    }

    public void setAisRedirectUrlToAspsp(String aisRedirectUrlToAspsp) {
        this.aisRedirectUrlToAspsp = aisRedirectUrlToAspsp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfileConfiguration)) {
            return false;
        }
        ProfileConfiguration other = (ProfileConfiguration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        List this$availablePaymentProducts = this.getAvailablePaymentProducts();
        List other$availablePaymentProducts = other.getAvailablePaymentProducts();
        if (this$availablePaymentProducts == null ? other$availablePaymentProducts != null : !((Object)this$availablePaymentProducts).equals(other$availablePaymentProducts)) {
            return false;
        }
        List this$availablePaymentTypes = this.getAvailablePaymentTypes();
        List other$availablePaymentTypes = other.getAvailablePaymentTypes();
        if (this$availablePaymentTypes == null ? other$availablePaymentTypes != null : !((Object)this$availablePaymentTypes).equals(other$availablePaymentTypes)) {
            return false;
        }
        ScaApproach this$scaApproach = this.getScaApproach();
        ScaApproach other$scaApproach = other.getScaApproach();
        if (this$scaApproach == null ? other$scaApproach != null : !this$scaApproach.equals(other$scaApproach)) {
            return false;
        }
        if (this.isTppSignatureRequired() != other.isTppSignatureRequired()) {
            return false;
        }
        String this$pisRedirectUrlToAspsp = this.getPisRedirectUrlToAspsp();
        String other$pisRedirectUrlToAspsp = other.getPisRedirectUrlToAspsp();
        if (this$pisRedirectUrlToAspsp == null ? other$pisRedirectUrlToAspsp != null : !this$pisRedirectUrlToAspsp.equals(other$pisRedirectUrlToAspsp)) {
            return false;
        }
        String this$aisRedirectUrlToAspsp = this.getAisRedirectUrlToAspsp();
        String other$aisRedirectUrlToAspsp = other.getAisRedirectUrlToAspsp();
        return !(this$aisRedirectUrlToAspsp == null ? other$aisRedirectUrlToAspsp != null : !this$aisRedirectUrlToAspsp.equals(other$aisRedirectUrlToAspsp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProfileConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFrequencyPerDay();
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        List $availablePaymentProducts = this.getAvailablePaymentProducts();
        result = result * 59 + ($availablePaymentProducts == null ? 43 : ((Object)$availablePaymentProducts).hashCode());
        List $availablePaymentTypes = this.getAvailablePaymentTypes();
        result = result * 59 + ($availablePaymentTypes == null ? 43 : ((Object)$availablePaymentTypes).hashCode());
        ScaApproach $scaApproach = this.getScaApproach();
        result = result * 59 + ($scaApproach == null ? 43 : $scaApproach.hashCode());
        result = result * 59 + (this.isTppSignatureRequired() ? 79 : 97);
        String $pisRedirectUrlToAspsp = this.getPisRedirectUrlToAspsp();
        result = result * 59 + ($pisRedirectUrlToAspsp == null ? 43 : $pisRedirectUrlToAspsp.hashCode());
        String $aisRedirectUrlToAspsp = this.getAisRedirectUrlToAspsp();
        result = result * 59 + ($aisRedirectUrlToAspsp == null ? 43 : $aisRedirectUrlToAspsp.hashCode());
        return result;
    }

    public String toString() {
        return "ProfileConfiguration(frequencyPerDay=" + this.getFrequencyPerDay() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", availablePaymentProducts=" + this.getAvailablePaymentProducts() + ", availablePaymentTypes=" + this.getAvailablePaymentTypes() + ", scaApproach=" + this.getScaApproach() + ", tppSignatureRequired=" + this.isTppSignatureRequired() + ", pisRedirectUrlToAspsp=" + this.getPisRedirectUrlToAspsp() + ", aisRedirectUrlToAspsp=" + this.getAisRedirectUrlToAspsp() + ")";
    }
}

