/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web;

import de.adorsys.aspsp.aspspmockserver.domain.Confirmation;
import de.adorsys.aspsp.aspspmockserver.domain.ConfirmationType;
import de.adorsys.aspsp.aspspmockserver.exception.ApiError;
import de.adorsys.aspsp.aspspmockserver.service.PaymentService;
import de.adorsys.aspsp.aspspmockserver.service.TanConfirmationService;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/consent/confirmation/pis"})
@Api(tags={"Payment confirmation for online banking"}, description="Provides access to email TAN confirmation for payment execution")
public class PaymentConfirmationController {
    private final TanConfirmationService tanConfirmationService;
    private final PaymentService paymentService;

    @PostMapping(path={"/{psu-id}"})
    @ApiOperation(value="Generates TAN for pis consent confirmation", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<Void> generateAndSendTan(@PathVariable(value="psu-id") String psuId) {
        return this.tanConfirmationService.generateAndSendTanForPsuById(psuId) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
    }

    @PutMapping
    @ApiOperation(value="Confirm TAN", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity confirmTan(@RequestBody Confirmation confirmation) {
        return CollectionUtils.isNotEmpty((Collection)this.paymentService.getPaymentById(confirmation.getPaymentId())) ? this.tanConfirmationService.confirmTan(confirmation.getPsuId(), confirmation.getTanNumber(), confirmation.getConsentId(), ConfirmationType.PAYMENT) : new ResponseEntity((Object)new ApiError(HttpStatus.BAD_REQUEST, "PAYMENT_MISSING", "Bad request"), HttpStatus.BAD_REQUEST);
    }

    @PutMapping(path={"/{consent-id}/{status}"})
    @ApiOperation(value="Update pis consent status of the corresponding consent", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    public ResponseEntity updatePisConsentStatus(@PathVariable(value="consent-id") String consentId, @PathVariable(value="status") SpiConsentStatus status) {
        this.paymentService.updatePaymentConsentStatus(consentId, status);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ConstructorProperties(value={"tanConfirmationService", "paymentService"})
    public PaymentConfirmationController(TanConfirmationService tanConfirmationService, PaymentService paymentService) {
        this.tanConfirmationService = tanConfirmationService;
        this.paymentService = paymentService;
    }
}

