/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.keycloak.KeycloakService;
import de.adorsys.aspsp.aspspmockserver.repository.PsuRepository;
import de.adorsys.aspsp.xs2a.spi.domain.psu.Psu;
import de.adorsys.aspsp.xs2a.spi.domain.psu.SpiScaMethod;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PsuService {
    private static final Logger log = LoggerFactory.getLogger(PsuService.class);
    private final PsuRepository psuRepository;
    private final KeycloakService keycloakService;

    public String createPsuAndReturnId(Psu psu) {
        if (!psu.isValid()) {
            log.error("Psu: {} is invalid", (Object)psu.getPsuId());
            return null;
        }
        if (this.psuRepository.findByPsuId(psu.getPsuId()).isPresent()) {
            log.error("Psu with psuId: {} is already exist", (Object)psu.getPsuId());
            return null;
        }
        if (!this.keycloakService.registerClient(psu.getPsuId(), psu.getPassword(), psu.getEmail())) {
            log.error("Can't register Psu: {} in Keycloak", (Object)psu.getPsuId());
            return null;
        }
        return ((Psu)this.psuRepository.save((Object)psu)).getAspspPsuId();
    }

    public Optional<Psu> getPsuByPsuId(String psuId) {
        return this.psuRepository.findByPsuId(psuId);
    }

    public List<Psu> getAllPsuList() {
        return this.psuRepository.findAll();
    }

    public boolean deletePsuByAspspPsuId(String aspspPsuId) {
        if (StringUtils.isNotBlank((CharSequence)aspspPsuId) && this.psuRepository.exists((Serializable)((Object)aspspPsuId))) {
            this.psuRepository.delete((Serializable)((Object)aspspPsuId));
            return true;
        }
        return false;
    }

    public List<String> getAllowedPaymentProducts(String iban) {
        return this.psuRepository.findPsuByAccountDetailsList_Iban(iban).map(Psu::getPermittedPaymentProducts).orElse(null);
    }

    public void addAllowedProduct(String psuId, String product) {
        List allowedProducts;
        Psu psu = this.getPsuByPsuId(psuId).orElse(null);
        if (psu != null && psu.isValid() && !(allowedProducts = psu.getPermittedPaymentProducts()).contains(product)) {
            allowedProducts.add(product);
            psu.setPermittedPaymentProducts(allowedProducts);
            this.psuRepository.save((Object)psu);
        }
    }

    public List<SpiScaMethod> getScaMethods(String psuId) {
        return this.psuRepository.findByPsuId(psuId).map(Psu::getScaMethods).orElse(null);
    }

    public void updateScaMethods(String psuId, List<SpiScaMethod> scaMethods) {
        this.psuRepository.findByPsuId(psuId).map(p -> {
            p.setScaMethods(scaMethods);
            return (Psu)this.psuRepository.save(p);
        });
    }

    @ConstructorProperties(value={"psuRepository", "keycloakService"})
    public PsuService(PsuRepository psuRepository, KeycloakService keycloakService) {
        this.psuRepository = psuRepository;
        this.keycloakService = keycloakService;
    }
}

