/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.repository.PsuRepository;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.aspsp.xs2a.spi.domain.psu.Psu;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AccountService {
    private final PsuRepository psuRepository;

    public Optional<SpiAccountDetails> addAccount(String psuId, SpiAccountDetails accountDetails) {
        return Optional.ofNullable(this.psuRepository.findOne((Serializable)((Object)psuId))).map(psu -> this.addAccountToPsuAndSave(psu, accountDetails)).flatMap(psu -> this.findAccountInPsuById(psu, accountDetails.getId()));
    }

    public List<SpiAccountDetails> getAllAccounts() {
        return this.psuRepository.findAll().stream().flatMap(psu -> psu.getAccountDetailsList().stream()).collect(Collectors.toList());
    }

    public Optional<SpiAccountDetails> getAccountById(String accountId) {
        return this.psuRepository.findPsuByAccountDetailsList_Id(accountId).flatMap(psu -> this.findAccountInPsuById(psu, accountId));
    }

    public List<SpiAccountDetails> getAccountsByIban(String iban) {
        return this.psuRepository.findPsuByAccountDetailsList_Iban(iban).map(psu -> psu.getAccountDetailsList().stream().filter(aD -> aD.getIban().equals(iban)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    Optional<String> getPsuIdByIban(String iban) {
        return this.psuRepository.findPsuByAccountDetailsList_Iban(iban).map(Psu::getPsuId);
    }

    Optional<Psu> getPsuByPsuId(String psuId) {
        return this.psuRepository.findByPsuId(psuId);
    }

    public List<SpiAccountBalance> getAccountBalancesById(String accountId) {
        return this.psuRepository.findPsuByAccountDetailsList_Id(accountId).flatMap(psu -> this.findAccountInPsuById(psu, accountId)).map(SpiAccountDetails::getBalances).orElse(Collections.emptyList());
    }

    public List<SpiAccountDetails> getAccountsByPsuId(String psuId) {
        return Optional.ofNullable(this.psuRepository.findOne((Serializable)((Object)psuId))).map(Psu::getAccountDetailsList).orElse(Collections.emptyList());
    }

    public void deleteAccountById(String accountId) {
        this.psuRepository.findPsuByAccountDetailsList_Id(accountId).map(psu -> this.getPsuWithFilteredAccountListById(psu, accountId)).map(arg_0 -> ((PsuRepository)this.psuRepository).save(arg_0));
    }

    Optional<SpiAccountDetails> updateAccount(SpiAccountDetails accountDetails) {
        return Optional.ofNullable(accountDetails.getId()).flatMap(arg_0 -> ((PsuRepository)this.psuRepository).findPsuByAccountDetailsList_Id(arg_0)).map(psu -> this.updateAccountInPsu(psu, accountDetails)).flatMap(psu -> this.findAccountInPsuById(psu, accountDetails.getId()));
    }

    private Psu updateAccountInPsu(Psu psu, SpiAccountDetails accountDetails) {
        Psu filteredPsu = this.getPsuWithFilteredAccountListById(psu, accountDetails.getId());
        return this.addAccountToPsuAndSave(filteredPsu, accountDetails);
    }

    private Optional<SpiAccountDetails> findAccountInPsuById(Psu psu, String accountId) {
        return psu.getAccountDetailsList().stream().filter(acc -> acc.getId().equals(accountId)).findFirst();
    }

    private Psu getPsuWithFilteredAccountListById(Psu psu, String accountId) {
        psu.setAccountDetailsList(this.getFilteredAccountDetailsListFromPsuById(psu, accountId));
        return psu;
    }

    private Psu addAccountToPsuAndSave(Psu psu, SpiAccountDetails accountDetails) {
        psu.getAccountDetailsList().add(accountDetails);
        return (Psu)this.psuRepository.save((Object)psu);
    }

    private List<SpiAccountDetails> getFilteredAccountDetailsListFromPsuById(Psu psu, String accountId) {
        return psu.getAccountDetailsList().stream().filter(ad -> !ad.getId().equals(accountId)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"psuRepository"})
    public AccountService(PsuRepository psuRepository) {
        this.psuRepository = psuRepository;
    }
}

