/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.data.test;

import de.adorsys.aspsp.aspspmockserver.repository.PaymentRepository;
import de.adorsys.aspsp.aspspmockserver.repository.PsuRepository;
import de.adorsys.aspsp.aspspmockserver.repository.TanRepository;
import de.adorsys.aspsp.aspspmockserver.repository.TransactionRepository;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPaymentType;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiBalanceType;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.aspsp.xs2a.spi.domain.payment.AspspPayment;
import de.adorsys.aspsp.xs2a.spi.domain.psu.Psu;
import de.adorsys.aspsp.xs2a.spi.domain.psu.SpiScaMethod;
import de.adorsys.aspsp.xs2a.spi.domain.psu.Tan;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"data_test"})
public class AccountMockServerData {
    private PsuRepository psuRepository;
    private TransactionRepository transactionRepository;
    private TanRepository tanRepository;
    private PaymentRepository paymentRepository;
    private List<SpiAccountDetails> accountDetails;
    private List<Psu> psus;
    private final List<String> ALLOWED_PAYMENTS = Collections.singletonList("sepa-credit-transfers");
    private final Currency EUR = Currency.getInstance("EUR");
    private final Currency USD = Currency.getInstance("USD");
    private final SpiBalanceType BALANCE_TYPE = SpiBalanceType.INTERIM_AVAILABLE;
    private final List<String> ALLOWED_PAYMENTS_CUCUMBER_TESTUSER = Arrays.asList("sepa-credit-transfers");

    public AccountMockServerData(PsuRepository psuRepository, TransactionRepository transactionRepository, TanRepository tanRepository, PaymentRepository paymentRepository) {
        this.psuRepository = psuRepository;
        this.transactionRepository = transactionRepository;
        this.tanRepository = tanRepository;
        this.paymentRepository = paymentRepository;
        this.accountDetails = this.fillAccounts();
        this.psus = this.fillPsu();
        this.fillTransactions();
        this.fillTanRepository();
        this.fillPayments();
    }

    private void fillPayments() {
        this.paymentRepository.save((Object)this.getPayment("a9115f14-4f72-4e4e-8798-202808e85238", (Psu)this.psus.get(3), this.EUR, BigDecimal.valueOf(150L), (Psu)this.psus.get(7), "Online-Shoppping Amazon", LocalDate.parse("2018-07-15"), LocalDateTime.parse("2018-07-15T18:30:35.035"), SpiTransactionStatus.RCVD, PisPaymentType.SINGLE, 15));
        this.paymentRepository.save((Object)this.getPayment("68147b90-e4ef-41c6-9c8b-c848c1e93700", (Psu)this.psus.get(3), this.EUR, BigDecimal.valueOf(1030L), (Psu)this.psus.get(8), "Holidays", LocalDate.parse("2018-07-31"), LocalDateTime.parse("2018-07-31T18:30:35.035"), SpiTransactionStatus.PDNG, PisPaymentType.SINGLE, 31));
        this.paymentRepository.save((Object)this.getPayment("97694f0d-32e2-43a4-9e8d-261f2fc28236", (Psu)this.psus.get(3), this.EUR, BigDecimal.valueOf(70L), (Psu)this.psus.get(9), "Concert Tickets", LocalDate.parse("2018-07-08"), LocalDateTime.parse("2018-07-08T18:30:35.035"), SpiTransactionStatus.RJCT, PisPaymentType.SINGLE, 8));
    }

    private AspspPayment getPayment(String paymentId, Psu debtor, Currency currency, BigDecimal amount, Psu creditor, String purposeCode, LocalDate requestedExecutionDate, LocalDateTime requestedExecutionTime, SpiTransactionStatus paymentStatus, PisPaymentType paymentType, int dayOfExecution) {
        AspspPayment payment = new AspspPayment();
        payment.setPaymentId(paymentId);
        payment.setDebtorAccount(this.getRef(debtor, currency));
        payment.setUltimateDebtor(this.getFirstElementName(debtor));
        payment.setInstructedAmount(new SpiAmount(currency, amount));
        payment.setCreditorAccount(this.getRef(creditor, currency));
        payment.setCreditorName(this.getFirstElementName(creditor));
        payment.setUltimateCreditor(this.getFirstElementName(creditor));
        payment.setPurposeCode(purposeCode);
        payment.setRequestedExecutionDate(requestedExecutionDate);
        payment.setRequestedExecutionTime(requestedExecutionTime);
        payment.setDayOfExecution(dayOfExecution);
        payment.setPisPaymentType(paymentType);
        payment.setPaymentStatus(paymentStatus);
        return payment;
    }

    private void fillTransactions() {
        this.transactionRepository.save((Object)this.getTransaction("0001", (Psu)this.psus.get(0), (Psu)this.psus.get(1), BigDecimal.valueOf(200L), this.EUR, LocalDate.parse("2018-01-02"), LocalDate.parse("2018-01-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0002", (Psu)this.psus.get(0), (Psu)this.psus.get(1), BigDecimal.valueOf(150L), this.USD, null, LocalDate.parse("2018-01-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0003", (Psu)this.psus.get(1), (Psu)this.psus.get(0), BigDecimal.valueOf(250L), this.EUR, LocalDate.parse("2018-02-02"), LocalDate.parse("2018-02-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0004", (Psu)this.psus.get(1), (Psu)this.psus.get(0), BigDecimal.valueOf(20L), this.USD, null, LocalDate.parse("2018-02-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0005", (Psu)this.psus.get(2), (Psu)this.psus.get(0), BigDecimal.valueOf(40L), this.EUR, LocalDate.parse("2018-03-02"), LocalDate.parse("2018-03-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0006", (Psu)this.psus.get(2), (Psu)this.psus.get(1), BigDecimal.valueOf(50L), this.USD, null, LocalDate.parse("2018-01-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0007", (Psu)this.psus.get(2), (Psu)this.psus.get(1), BigDecimal.valueOf(120L), this.EUR, LocalDate.parse("2018-01-02"), LocalDate.parse("2018-01-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0008", (Psu)this.psus.get(1), (Psu)this.psus.get(2), BigDecimal.valueOf(30L), this.USD, null, LocalDate.parse("2018-02-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0009", (Psu)this.psus.get(1), (Psu)this.psus.get(2), BigDecimal.valueOf(80L), this.EUR, LocalDate.parse("2018-02-02"), LocalDate.parse("2018-02-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("ba8f7012-bdaf-4ada-bbf7-4c004d046ffe", (Psu)this.psus.get(4), (Psu)this.psus.get(3), BigDecimal.valueOf(50L), this.EUR, LocalDate.parse("2018-07-05"), LocalDate.parse("2018-07-05"), "Spende Greenpeace"));
        this.transactionRepository.save((Object)this.getTransaction("7d12ff85-8ace-4124-877a-6bc3f125e98b", (Psu)this.psus.get(5), (Psu)this.psus.get(3), BigDecimal.valueOf(45.99), this.EUR, LocalDate.parse("2018-01-01"), LocalDate.parse("2018-01-01"), "Internet Rechnung Januar 2018 - MC-13058247-00000002"));
        this.transactionRepository.save((Object)this.getTransaction("bb0962ca-f6db-4ba7-b187-2b2e1af25845", (Psu)this.psus.get(6), (Psu)this.psus.get(3), BigDecimal.valueOf(200L), this.EUR, LocalDate.parse("2018-05-15"), LocalDate.parse("2018-05-15"), "Alles Gute zum Geburtstag"));
    }

    private SpiTransaction getTransaction(String transactionId, Psu psu, Psu debtor, BigDecimal amount, Currency currency, LocalDate bookingDate, LocalDate valueDate, String purposeCode) {
        return new SpiTransaction(transactionId, "", "", "", "", psu.getPsuId(), bookingDate, valueDate, new SpiAmount(currency, amount), Collections.emptyList(), this.getFirstElementName(psu), this.getRef(psu, currency), this.getFirstElementName(psu), this.getFirstElementName(debtor), this.getRef(debtor, currency), this.getFirstElementName(debtor), "", "", purposeCode, "", "");
    }

    private String getFirstElementName(Psu creditor) {
        return ((SpiAccountDetails)creditor.getAccountDetailsList().get(0)).getName();
    }

    private SpiAccountReference getRef(Psu psu, Currency currency) {
        return psu.getAccountDetailsList().stream().filter(det -> det.getCurrency() == currency).map(arg_0 -> this.mapToReferenceFromDetails(arg_0)).findFirst().get();
    }

    private List<Psu> fillPsu() {
        return Arrays.asList((Psu)this.psuRepository.save((Object)new Psu("PSU_001", "fractal567@gmail.com", "aspsp", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(0), (SpiAccountDetails)this.accountDetails.get(1), (SpiAccountDetails)this.accountDetails.get(2)), this.ALLOWED_PAYMENTS, Collections.emptyList())), (Psu)this.psuRepository.save((Object)new Psu("PSU_002", "fractal567@gmail.com", "aspsp1", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(0), (SpiAccountDetails)this.accountDetails.get(1), (SpiAccountDetails)this.accountDetails.get(2)), this.ALLOWED_PAYMENTS, Arrays.asList(SpiScaMethod.SMS_OTP))), (Psu)this.psuRepository.save((Object)new Psu("PSU_003", "fractal567@gmail.com", "aspsp2", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(3), (SpiAccountDetails)this.accountDetails.get(4)), this.ALLOWED_PAYMENTS, Arrays.asList(SpiScaMethod.SMS_OTP, SpiScaMethod.PUSH_OTP))), (Psu)this.psuRepository.save((Object)new Psu("PSU_004", "fractal567@gmail.com", "aspsp3", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(5), (SpiAccountDetails)this.accountDetails.get(6)), this.ALLOWED_PAYMENTS, Arrays.asList(SpiScaMethod.PUSH_OTP, SpiScaMethod.CHIP_OTP))), (Psu)this.psuRepository.save((Object)new Psu("d9e71419-24e4-4c5a-8d93-fcc23153aaff", "mueller.alex@web.de", "aspsp4", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(7)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(SpiScaMethod.SMS_OTP))), (Psu)this.psuRepository.save((Object)new Psu("d9e71419-24e4-4c5a-8d93-fcc23153aaff", "mueller.alex@web.de", "aspsp5", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(7)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(SpiScaMethod.SMS_OTP))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberGreenpeace", "greenpeace@web.de", "aspsp6", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(8)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(SpiScaMethod.SMS_OTP))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberTelekom", "telekom@telekom.de", "aspsp7", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(9)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(SpiScaMethod.SMS_OTP))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberJochen", "jochen.mueller@web.de", "aspsp8", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(10)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(SpiScaMethod.SMS_OTP))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberAmazon", "amazon@mail.com", "aspsp9", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(11)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(SpiScaMethod.SMS_OTP))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberHolidayCheck", "holidaycheck@mail.com", "aspsp10", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(12)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(SpiScaMethod.SMS_OTP))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberEventim", "eventim@web.de", "aspsp11", "zzz", Arrays.asList((SpiAccountDetails)this.accountDetails.get(13)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(SpiScaMethod.SMS_OTP))));
    }

    private List<SpiAccountDetails> fillAccounts() {
        return Arrays.asList(this.getNewAccount("11111-999999999", this.getNewBalanceList(this.EUR, BigDecimal.valueOf(1000L)), "DE89370400440532013000", "AEYPM5403H", "DEUTDE8EXXX", "M\u00fcller", "SCT"), this.getNewAccount("77777-999999999", this.getNewBalanceList(this.USD, BigDecimal.valueOf(350L)), "DE89370400440532013000", "FFGHPM5403H", "DEUTDE8EXXX", "M\u00fcller", "SCT"), this.getNewAccount("22222-999999999", this.getNewBalanceList(this.USD, BigDecimal.valueOf(2500L)), "DE89370400440532013001", "QWEPM6427U", "DEUTDE8EXXX", "M\u00fcller", "SCT"), this.getNewAccount("33333-999999999", this.getNewBalanceList(this.EUR, BigDecimal.valueOf(3000L)), "LU280019400644750000", "EWQPS8534R", "DEUTDE8EXXX", "Schmidt", "SCT"), this.getNewAccount("44444-999999999", this.getNewBalanceList(this.USD, BigDecimal.valueOf(3500L)), "DE89370400440532013003", "ASDPS9547Z", "DEUTDE8EXXX", "Schmidt", "SCT"), this.getNewAccount("55555-999999999", this.getNewBalanceList(this.EUR, BigDecimal.valueOf(4000L)), "DE89370400440532013004", "DSACC1876N", "DEUTDE8EXXX", "Company AG", "SCT"), this.getNewAccount("66666-999999999", this.getNewBalanceList(this.USD, BigDecimal.valueOf(1400L)), "DE89370400440532013005", "CXZCC6427T", "DEUTDE8EXXX", "Company AG", "SCT"), this.getNewAccountCucumberTest("42fb4cc3-91cb-45ba-9159-b87acf6d8add", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(50000L)), "DE52500105173911841934", null, null, "Alexander Mueller", "GIRO"), this.getNewAccountCucumberTest("88888-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(1000000L)), "DE24500105172916349286", null, null, "Greenpeace", "GIRO"), this.getNewAccountCucumberTest("99999-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(500000L)), "DE68500105174416628385", null, null, "Telekom", "GIRO"), this.getNewAccountCucumberTest("12345-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(20000L)), "DE06500105171657611553", null, null, "Jochen Mueller", "GIRO"), this.getNewAccountCucumberTest("23236-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(6500000L)), "DE49500105175378548627", null, null, "Amazon", "GIRO"), this.getNewAccountCucumberTest("37289-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(9500000L)), "DE21500105176194357737", null, null, "Holidaycheck.com", "GIRO"), this.getNewAccountCucumberTest("10023-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(2500000L)), "DE54500105173424724776", null, null, "Eventim", "GIRO"));
    }

    private SpiAccountDetails getNewAccount(String id, List<SpiAccountBalance> balance, String iban, String pan, String bic, String name, String accountType) {
        return new SpiAccountDetails(id, iban, iban.substring(3), pan, pan.substring(3) + "****", null, balance.get(0).getSpiBalanceAmount().getCurrency(), name, accountType, null, null, bic, null, null, null, balance);
    }

    private List<SpiAccountBalance> getNewBalanceList(Currency currency, BigDecimal amount1) {
        return Collections.singletonList(this.getBalance(currency, amount1, LocalDate.now(), LocalDateTime.now()));
    }

    private SpiAccountBalance getBalance(Currency currency, BigDecimal amount, LocalDate date, LocalDateTime dateTime) {
        SpiAccountBalance balance = new SpiAccountBalance();
        balance.setSpiBalanceAmount(new SpiAmount(currency, amount));
        balance.setSpiBalanceType(this.BALANCE_TYPE);
        balance.setReferenceDate(date);
        balance.setLastChangeDateTime(dateTime);
        balance.setLastCommittedTransaction("abcd");
        return balance;
    }

    private SpiAccountDetails getNewAccountCucumberTest(String id, List<SpiAccountBalance> balance, String iban, String pan, String bic, String name, String accountType) {
        return new SpiAccountDetails(id, iban, iban.substring(3), pan, null, null, balance.get(0).getSpiBalanceAmount().getCurrency(), name, accountType, null, null, bic, null, null, null, balance);
    }

    private List<SpiAccountBalance> getNewBalanceListCucumberTests(Currency currency, BigDecimal amount1) {
        return Collections.singletonList(this.getBalance(currency, amount1, LocalDate.now(), LocalDateTime.now()));
    }

    private SpiAccountReference mapToReferenceFromDetails(SpiAccountDetails details) {
        return new SpiAccountReference(details.getIban(), details.getBban(), details.getPan(), details.getMaskedPan(), details.getMsisdn(), details.getCurrency());
    }

    private void fillTanRepository() {
        this.tanRepository.save((Object)new Tan("PSU_001", "111111"));
        this.tanRepository.save((Object)new Tan("PSU_002", "222222"));
        this.tanRepository.save((Object)new Tan("PSU_003", "333333"));
    }
}

