/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web.rest;

import de.adorsys.aspsp.aspspmockserver.service.TransactionService;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiTransaction;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/transaction"})
@Api(tags={"Transactions"}, description="Provides access to transactions")
public class TransactionController {
    private final TransactionService transactionService;

    @ApiOperation(value="Returns a list of all transactions available at ASPSP", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=List.class), @ApiResponse(code=404, message="Not Found")})
    @GetMapping(path={"/"})
    public ResponseEntity<List<SpiTransaction>> readAllTransactions() {
        List transactions = this.transactionService.getAllTransactions();
        return CollectionUtils.isEmpty((Collection)transactions) ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)transactions);
    }

    @ApiOperation(value="Returns a transaction by its ASPSP identifier and account identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SpiTransaction.class), @ApiResponse(code=204, message="No Content")})
    @GetMapping(path={"/{transaction-id}/{account-id}"})
    public ResponseEntity<SpiTransaction> readTransactionById(@PathVariable(value="transaction-id") String transactionId, @PathVariable(value="account-id") String accountId) {
        return this.transactionService.getTransactionById(transactionId, accountId).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.noContent().build());
    }

    @ApiOperation(value="Creates a transaction at ASPSP", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=String.class), @ApiResponse(code=400, message="Bad Request")})
    @PostMapping(path={"/"})
    public ResponseEntity createTransaction(@RequestBody SpiTransaction transaction) {
        return this.transactionService.saveTransaction(transaction).map(transactionId -> new ResponseEntity(transactionId, HttpStatus.CREATED)).orElse(ResponseEntity.badRequest().build());
    }

    @ApiOperation(value="Returns a list of transactions for account by its ASPSP identifier for a certain period of time bounded by dates from/to", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=204, message="No Content")})
    @GetMapping(path={"/{account-id}"})
    public ResponseEntity<List<SpiTransaction>> readTransactionsByPeriod(@PathVariable(value="account-id") String accountId, @RequestParam(value="dateFrom") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dateFrom, @RequestParam(value="dateTo") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dateTo) {
        List response = this.transactionService.getTransactionsByPeriod(accountId, dateFrom, dateTo);
        return CollectionUtils.isEmpty((Collection)response) ? ResponseEntity.noContent().build() : ResponseEntity.ok((Object)response);
    }

    @ConstructorProperties(value={"transactionService"})
    public TransactionController(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

