/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web.rest;

import de.adorsys.aspsp.aspspmockserver.service.PsuService;
import de.adorsys.aspsp.xs2a.spi.domain.psu.Psu;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/psu"})
@Api(tags={"PSUs"}, description="Provides access to the Psu`s")
public class PsuController {
    private final PsuService psuService;

    @ApiOperation(value="Returns a list of all PSU`s available at ASPSP", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=204, message="Not Content")})
    @GetMapping(path={"/"})
    public ResponseEntity<List<Psu>> readAllPsuList() {
        List psus = this.psuService.getAllPsuList();
        return CollectionUtils.isNotEmpty((Collection)psus) ? ResponseEntity.ok((Object)psus) : ResponseEntity.noContent().build();
    }

    @ApiOperation(value="Returns a PSU by its ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=204, message="Not Content")})
    @GetMapping(path={"/{psu-id}"})
    public ResponseEntity<Psu> readPsuById(@PathVariable(value="psu-id") String psuId) {
        return this.psuService.getPsuById(psuId).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @ApiOperation(value="Returns a list of allowed payment products for PSU by its ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=204, message="Not Content")})
    @GetMapping(path={"/allowed-payment-products/{iban}"})
    public ResponseEntity<List<String>> readPaymentProductsById(@PathVariable(value="iban") String iban) {
        return Optional.ofNullable(this.psuService.getAllowedPaymentProducts(iban)).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @ApiOperation(value="Adds a payment product to the list of allowed products for PSU specified by its ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class)})
    @PutMapping(path={"/allowed-payment-products/{psu-id}/{product}"})
    public void addPaymentProduct(@PathVariable(value="psu-id") String psuId, @PathVariable(value="product") String product) {
        this.psuService.addAllowedProduct(psuId, product);
    }

    @ApiOperation(value="Creates a PSU at ASPSP", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="Created", response=String.class), @ApiResponse(code=400, message="Bad Request")})
    @PostMapping(path={"/"})
    public ResponseEntity<String> createPsu(@RequestBody Psu psu) {
        String saved = this.psuService.createPsuAndReturnId(psu);
        return StringUtils.isNotBlank((CharSequence)saved) ? ResponseEntity.ok((Object)saved) : ResponseEntity.badRequest().build();
    }

    @ApiOperation(value="Removes PSU from ASPSP by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=404, message="Not Found")})
    @DeleteMapping(path={"/{psu-id}"})
    public ResponseEntity deletePsu(@PathVariable(value="psu-id") String psuId) {
        return this.psuService.deletePsuById(psuId) ? ResponseEntity.noContent().build() : ResponseEntity.notFound().build();
    }

    @ConstructorProperties(value={"psuService"})
    public PsuController(PsuService psuService) {
        this.psuService = psuService;
    }
}

