/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web.rest;

import de.adorsys.aspsp.aspspmockserver.service.PaymentService;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.aspsp.xs2a.spi.domain.payment.AspspPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayments;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/payments"})
@Api(tags={"Payments"}, description="Provides access to payments")
public class PaymentController {
    private PaymentService paymentService;

    @ApiOperation(value="Creates a single payment based on request body", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=SpiSinglePayments.class), @ApiResponse(code=204, message="Payment Failed")})
    @PostMapping(path={"/"})
    public ResponseEntity<SpiSinglePayments> createPayment(@RequestBody SpiSinglePayments payment) {
        return this.paymentService.addPayment(payment).map(saved -> new ResponseEntity(saved, HttpStatus.CREATED)).orElse(ResponseEntity.noContent().build());
    }

    @ApiOperation(value="Creates a bulk payment(list of single payments) based on request body", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=List.class), @ApiResponse(code=204, message="Payment Failed")})
    @PostMapping(path={"/bulk-payments"})
    public ResponseEntity<List<SpiSinglePayments>> createBulkPayments(@RequestBody List<SpiSinglePayments> payments) {
        List saved = this.paymentService.addBulkPayments(payments);
        return CollectionUtils.isEmpty((Collection)saved) ? ResponseEntity.noContent().build() : new ResponseEntity((Object)saved, HttpStatus.CREATED);
    }

    @ApiOperation(value="Returns the status of payment requested by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SpiTransactionStatus.class), @ApiResponse(code=204, message="Payment Not Found")})
    @GetMapping(path={"/{paymentId}/status"})
    public ResponseEntity<SpiTransactionStatus> getPaymentStatusById(@PathVariable(value="paymentId") String paymentId) {
        return this.paymentService.getPaymentStatusById(paymentId).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @ApiOperation(value="Creates a periodic payment based on request body", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=SpiPeriodicPayment.class), @ApiResponse(code=400, message="Bad Request")})
    @PostMapping(path={"/create-periodic-payment"})
    public ResponseEntity<SpiPeriodicPayment> createPeriodicPayment(@RequestBody SpiPeriodicPayment payment) {
        return this.paymentService.addPeriodicPayment(payment).map(saved -> new ResponseEntity(saved, HttpStatus.CREATED)).orElse(ResponseEntity.badRequest().build());
    }

    @ApiOperation(value="Returns all payments present at ASPSP", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AspspPayment.class)})
    @GetMapping(path={"/getAllPayments"})
    public ResponseEntity<List<AspspPayment>> getAllPayments() {
        List allPayments = this.paymentService.getAllPayments();
        return ResponseEntity.ok((Object)allPayments);
    }

    @ApiOperation(value="Returns the requested payment by it's paymentId", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AspspPayment.class)})
    @GetMapping(path={"/{paymentId}"})
    public ResponseEntity<AspspPayment> getPaymentById(@PathVariable(value="paymentId") String paymentId) {
        return this.paymentService.getPaymentById(paymentId).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @ApiOperation(value="Returns the payment requested by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AspspPayment.class), @ApiResponse(code=204, message="Payment Not Found")})
    @GetMapping(path={"/{payment-type}/{payment-product}/{paymentId}"})
    public ResponseEntity<AspspPayment> getPaymentByIdAndTypeAndProduct(@PathVariable(value="payment-type") String paymentType, @PathVariable(value="payment-product") String paymentProduct, @PathVariable(value="paymentId") String paymentId) {
        return this.paymentService.getPaymentById(paymentId).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @ConstructorProperties(value={"paymentService"})
    public PaymentController(PaymentService paymentService) {
        this.paymentService = paymentService;
    }
}

