/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web.rest;

import de.adorsys.aspsp.aspspmockserver.domain.PaymentConfirmation;
import de.adorsys.aspsp.aspspmockserver.service.PaymentConfirmationService;
import de.adorsys.aspsp.aspspmockserver.service.PaymentService;
import de.adorsys.aspsp.aspspmockserver.web.util.ApiError;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(path={"/view/payment/confirmation"})
@Api(tags={"TAN confirmation"}, description="Provides access to email TAN confirmation for payment execution")
public class PaymentConfirmationController {
    @Value(value="${onlinebanking-mock-webapp.baseurl}")
    private String onlineBankingMockWebappUrl;
    private final PaymentConfirmationService paymentConfirmationService;
    private final PaymentService paymentService;

    @GetMapping(path={"/{iban}/{consent-id}/{payment-id}"})
    @ApiOperation(value="Sends TAN to psu`s email, validates TAN sent to PSU`s e-mail and returns a link to continue as authenticated user")
    public void showConfirmationPage(@PathVariable(value="iban") String iban, @PathVariable(value="consent-id") String consentId, @PathVariable(value="payment-id") String paymentId, HttpServletResponse response) throws IOException {
        this.paymentConfirmationService.generateAndSendTanForPsuByIban(iban);
        UriComponents uriComponents = UriComponentsBuilder.newInstance().path("/{iban}/{consentId}/{paymentId}").buildAndExpand(new Object[]{iban, consentId, paymentId});
        response.sendRedirect(this.onlineBankingMockWebappUrl + uriComponents.toUriString());
    }

    @PostMapping
    @ApiOperation(value="Validates tan")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity confirmTan(@RequestBody PaymentConfirmation paymentConfirmation) {
        Optional payment = this.paymentService.getPaymentById(paymentConfirmation.getPaymentId());
        if (payment.isPresent()) {
            if (this.paymentConfirmationService.isTanNumberValidByIban(paymentConfirmation.getIban(), paymentConfirmation.getTanNumber(), paymentConfirmation.getConsentId())) {
                return new ResponseEntity(HttpStatus.OK);
            }
            ApiError error = new ApiError(HttpStatus.BAD_REQUEST, "WRONG_TAN", "Bad request");
            return new ResponseEntity((Object)error, error.getStatus());
        }
        ApiError error = new ApiError(HttpStatus.BAD_REQUEST, "PAYMENT_MISSING", "Bad request");
        return new ResponseEntity((Object)error, error.getStatus());
    }

    @PostMapping(path={"/consent"}, params={"decision=confirmed"})
    @ApiOperation(value="Proceeds payment and changes the status of the corresponding consent")
    public ResponseEntity proceedPayment(@RequestBody PaymentConfirmation paymentConfirmation) {
        this.paymentService.updatePaymentConsentStatus(paymentConfirmation.getConsentId(), SpiConsentStatus.VALID);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(path={"/consent"}, params={"decision=revoked"})
    @ApiOperation(value="Shows payment failure page")
    public ResponseEntity revokePaymentConsent(@RequestBody PaymentConfirmation paymentConfirmation) {
        this.paymentService.updatePaymentConsentStatus(paymentConfirmation.getConsentId(), SpiConsentStatus.REVOKED_BY_PSU);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ConstructorProperties(value={"paymentConfirmationService", "paymentService"})
    public PaymentConfirmationController(PaymentConfirmationService paymentConfirmationService, PaymentService paymentService) {
        this.paymentConfirmationService = paymentConfirmationService;
        this.paymentService = paymentService;
    }
}

