/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web.rest;

import de.adorsys.aspsp.aspspmockserver.service.FutureBookingsService;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountDetails;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/future-bookings"})
@Api(tags={"Future payments"}, description="Provides access to future payment execution")
public class FutureBookingsController {
    private final FutureBookingsService futureBookingsService;

    @ApiOperation(value="Executes future payments for account specified by IBAN and Currency, with update on corresponding account balances", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SpiAccountDetails.class), @ApiResponse(code=204, message="No Content")})
    @PostMapping(path={"/{iban}/{currency}"})
    public ResponseEntity<SpiAccountDetails> changeBalances(@PathVariable(value="iban") String iban, @PathVariable(value="currency") String currency) {
        return this.futureBookingsService.changeBalances(iban, currency).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @ConstructorProperties(value={"futureBookingsService"})
    public FutureBookingsController(FutureBookingsService futureBookingsService) {
        this.futureBookingsService = futureBookingsService;
    }
}

