/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web.rest;

import de.adorsys.aspsp.aspspmockserver.service.AccountService;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountDetails;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/account"})
@Api(tags={"PSU Accounts"}, description="Provides access to the Psu`s accounts")
public class AccountController {
    private final AccountService accountService;

    @ApiOperation(value="Returns all accounts available at ASPSP.", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=204, message="No Content")})
    @GetMapping(path={"/"})
    public ResponseEntity<List<SpiAccountDetails>> readAllAccounts() {
        return Optional.ofNullable(this.accountService.getAllAccounts()).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.noContent().build());
    }

    @ApiOperation(value="Returns account details specified by ASPSP account identifier.", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SpiAccountDetails.class), @ApiResponse(code=204, message="Not Content")})
    @GetMapping(path={"/{accountId}"})
    public ResponseEntity<SpiAccountDetails> readAccountById(@PathVariable(value="accountId") String accountId) {
        return this.accountService.getAccountById(accountId).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.noContent().build());
    }

    @ApiOperation(value="Creates an account for a specific PSU.", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=SpiAccountDetails.class), @ApiResponse(code=400, message="Bad Request")})
    @PutMapping(path={"/"})
    public ResponseEntity createAccount(@RequestParam String psuId, @RequestBody SpiAccountDetails account) {
        return this.accountService.addAccount(psuId, account).map(acc -> new ResponseEntity(acc, HttpStatus.CREATED)).orElse(ResponseEntity.badRequest().build());
    }

    @ApiOperation(value="Removes PSU account by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=204, message="Not Content")})
    @DeleteMapping(path={"/{accountId}"})
    public ResponseEntity deleteAccount(@PathVariable(value="accountId") String accountId) {
        this.accountService.deleteAccountById(accountId);
        return ResponseEntity.noContent().build();
    }

    @ApiOperation(value="Returns a list of balances for certain account by ASPSP account identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=204, message="No Content")})
    @GetMapping(path={"/{accountId}/balances"})
    public ResponseEntity<List<SpiAccountBalance>> readBalancesById(@PathVariable(value="accountId") String accountId) {
        List response = this.accountService.getAccountBalancesById(accountId);
        return CollectionUtils.isEmpty((Collection)response) ? ResponseEntity.noContent().build() : ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="Returns a list of PSU`s account details by ASPSP PSU identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=204, message="No Content")})
    @GetMapping(path={"/psu/{psuId}"})
    public ResponseEntity<List<SpiAccountDetails>> readAccountsByPsuId(@PathVariable(value="psuId") String psuId) {
        List response = this.accountService.getAccountsByPsuId(psuId);
        return CollectionUtils.isEmpty((Collection)response) ? ResponseEntity.noContent().build() : ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="Returns a list of account details selected by IBAN", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=204, message="No Content")})
    @GetMapping(path={"/iban/{iban}"})
    public ResponseEntity<List<SpiAccountDetails>> readAccountsByIban(@PathVariable(value="iban") String iban) {
        List response = this.accountService.getAccountsByIban(iban);
        return CollectionUtils.isEmpty((Collection)response) ? ResponseEntity.noContent().build() : ResponseEntity.ok((Object)response);
    }

    @ConstructorProperties(value={"accountService"})
    public AccountController(AccountService accountService) {
        this.accountService = accountService;
    }
}

