/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.repository.TransactionRepository;
import de.adorsys.aspsp.aspspmockserver.service.AccountService;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiTransaction;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class TransactionService {
    private final TransactionRepository transactionRepository;
    private final AccountService accountService;

    public List<SpiTransaction> getAllTransactions() {
        return this.transactionRepository.findAll();
    }

    public Optional<SpiTransaction> getTransactionById(String transactionId, String accountId) {
        Optional details = this.accountService.getAccountById(accountId);
        return details.map(det -> this.transactionRepository.findOneByTransactionIdAndAccount(det.getIban(), det.getCurrency(), transactionId));
    }

    public Optional<String> saveTransaction(SpiTransaction transaction) {
        return Optional.ofNullable(this.transactionRepository.save((Object)transaction)).map(SpiTransaction::getTransactionId);
    }

    public List<SpiTransaction> getTransactionsByPeriod(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        Optional details = this.accountService.getAccountById(accountId);
        return details.map(det -> this.transactionRepository.findAllByDates(det.getIban(), det.getCurrency(), dateFrom, dateTo)).orElse(Collections.emptyList());
    }

    @ConstructorProperties(value={"transactionRepository", "accountService"})
    public TransactionService(TransactionRepository transactionRepository, AccountService accountService) {
        this.transactionRepository = transactionRepository;
        this.accountService = accountService;
    }
}

