/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.repository.PsuRepository;
import de.adorsys.aspsp.xs2a.spi.domain.psu.Psu;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsuService {
    private PsuRepository psuRepository;

    @Autowired
    public PsuService(PsuRepository psuRepository) {
        this.psuRepository = psuRepository;
    }

    public String createPsuAndReturnId(Psu psu) {
        return psu.isValid() ? ((Psu)this.psuRepository.save((Object)psu)).getId() : null;
    }

    public Optional<Psu> getPsuById(String psuId) {
        return Optional.ofNullable(this.psuRepository.findOne((Serializable)((Object)psuId)));
    }

    public List<Psu> getAllPsuList() {
        return this.psuRepository.findAll();
    }

    public boolean deletePsuById(String psuId) {
        if (StringUtils.isNotBlank((CharSequence)psuId) && this.psuRepository.exists((Serializable)((Object)psuId))) {
            this.psuRepository.delete((Serializable)((Object)psuId));
            return true;
        }
        return false;
    }

    public List<String> getAllowedPaymentProducts(String iban) {
        return this.psuRepository.findPsuByAccountDetailsList_Iban(iban).map(Psu::getPermittedPaymentProducts).orElse(null);
    }

    public void addAllowedProduct(String psuId, String product) {
        List allowedProducts;
        Psu psu = this.getPsuById(psuId).orElse(null);
        if (psu != null && psu.isValid() && !(allowedProducts = psu.getPermittedPaymentProducts()).contains(product)) {
            allowedProducts.add(product);
            psu.setPermittedPaymentProducts(allowedProducts);
            this.psuRepository.save((Object)psu);
        }
    }
}

