/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.config.rest.consent.PisConsentRemoteUrls;
import de.adorsys.aspsp.aspspmockserver.repository.PaymentRepository;
import de.adorsys.aspsp.aspspmockserver.service.AccountService;
import de.adorsys.aspsp.aspspmockserver.service.mapper.PaymentMapper;
import de.adorsys.aspsp.xs2a.consent.api.pis.PisPaymentType;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import de.adorsys.aspsp.xs2a.spi.domain.payment.AspspPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.aspsp.xs2a.spi.domain.payment.SpiSinglePayments;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PaymentService {
    private final PaymentRepository paymentRepository;
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final PisConsentRemoteUrls remotePisConsentUrls;
    private final PaymentMapper paymentMapper;
    private final AccountService accountService;

    public Optional<SpiSinglePayments> addPayment(@NotNull SpiSinglePayments payment) {
        if (this.areFundsSufficient(payment.getDebtorAccount(), payment.getInstructedAmount().getContent())) {
            AspspPayment saved = (AspspPayment)this.paymentRepository.save((Object)this.paymentMapper.mapToAspspPayment(payment, PisPaymentType.SINGLE));
            return Optional.ofNullable(this.paymentMapper.mapToSpiSinglePayments(saved));
        }
        return Optional.empty();
    }

    public Optional<SpiPeriodicPayment> addPeriodicPayment(@NotNull SpiPeriodicPayment payment) {
        AspspPayment saved = (AspspPayment)this.paymentRepository.save((Object)this.paymentMapper.mapToAspspPayment(payment, PisPaymentType.PERIODIC));
        return Optional.ofNullable(this.paymentMapper.mapToSpiPeriodicPayment(saved));
    }

    public boolean isPaymentExist(String paymentId) {
        return this.paymentRepository.exists((Serializable)((Object)paymentId));
    }

    public Optional<SpiTransactionStatus> getPaymentStatusById(String paymentId) {
        return Optional.ofNullable(this.paymentRepository.findOne((Serializable)((Object)paymentId))).map(AspspPayment::getPaymentStatus);
    }

    public List<SpiSinglePayments> addBulkPayments(List<SpiSinglePayments> payments) {
        List aspspPayments = payments.stream().filter(payment -> this.areFundsSufficient(payment.getDebtorAccount(), payment.getInstructedAmount().getContent())).map(payment -> this.paymentMapper.mapToAspspPayment(payment, PisPaymentType.BULK)).collect(Collectors.toList());
        List saved = this.paymentRepository.save(aspspPayments);
        return saved.stream().map(arg_0 -> ((PaymentMapper)this.paymentMapper).mapToSpiPeriodicPayment(arg_0)).collect(Collectors.toList());
    }

    BigDecimal calculateAmountToBeCharged(String accountId) {
        return this.paymentRepository.findAll().stream().filter(paym -> this.getDebtorAccountIdFromPayment(paym).equals(accountId)).map(arg_0 -> this.getAmountFromPayment(arg_0)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void updatePaymentConsentStatus(@NotNull String consentId, SpiConsentStatus consentStatus) {
        this.consentRestTemplate.put(this.remotePisConsentUrls.updatePisConsentStatus(), null, new Object[]{consentId, consentStatus.name()});
    }

    private boolean areFundsSufficient(SpiAccountReference reference, BigDecimal amount) {
        Optional<Boolean> balance = Optional.ofNullable(reference).flatMap(arg_0 -> this.getInterimAvailableBalanceByReference(arg_0));
        return balance.map(b -> b.getSpiBalanceAmount().getContent().compareTo(amount) > 0).orElse(false);
    }

    private Optional<SpiAccountBalance> getInterimAvailableBalanceByReference(SpiAccountReference reference) {
        List accountsByIban = this.accountService.getAccountsByIban(reference.getIban());
        return this.filterDetailsByCurrency(accountsByIban, reference.getCurrency()).flatMap(SpiAccountDetails::getFirstBalance);
    }

    private Optional<SpiAccountDetails> filterDetailsByCurrency(List<SpiAccountDetails> accounts, Currency currency) {
        return Optional.ofNullable(accounts).flatMap(accs -> accs.stream().filter(ac -> ac.getCurrency() == currency).findFirst());
    }

    private String getDebtorAccountIdFromPayment(AspspPayment aspspPayment) {
        return Optional.ofNullable(aspspPayment.getDebtorAccount()).map(SpiAccountReference::getIban).orElse("");
    }

    private BigDecimal getAmountFromPayment(AspspPayment aspspPayment) {
        return Optional.ofNullable(aspspPayment).map(paym -> this.getContentFromAmount(aspspPayment.getInstructedAmount())).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getContentFromAmount(SpiAmount amount) {
        return Optional.ofNullable(amount).map(SpiAmount::getContent).orElse(BigDecimal.ZERO);
    }

    public Optional<AspspPayment> getPaymentById(String paymentId) {
        return Optional.ofNullable(this.paymentRepository.findOne((Serializable)((Object)paymentId)));
    }

    public List<AspspPayment> getAllPayments() {
        return this.paymentRepository.findAll();
    }

    @ConstructorProperties(value={"paymentRepository", "consentRestTemplate", "remotePisConsentUrls", "paymentMapper", "accountService"})
    public PaymentService(PaymentRepository paymentRepository, RestTemplate consentRestTemplate, PisConsentRemoteUrls remotePisConsentUrls, PaymentMapper paymentMapper, AccountService accountService) {
        this.paymentRepository = paymentRepository;
        this.consentRestTemplate = consentRestTemplate;
        this.remotePisConsentUrls = remotePisConsentUrls;
        this.paymentMapper = paymentMapper;
        this.accountService = accountService;
    }
}

