/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.repository.PsuRepository;
import de.adorsys.aspsp.aspspmockserver.repository.TanRepository;
import de.adorsys.aspsp.aspspmockserver.service.AccountService;
import de.adorsys.aspsp.aspspmockserver.service.PaymentService;
import de.adorsys.aspsp.xs2a.spi.domain.consent.SpiConsentStatus;
import de.adorsys.aspsp.xs2a.spi.domain.psu.Tan;
import de.adorsys.aspsp.xs2a.spi.domain.psu.TanStatus;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class PaymentConfirmationService {
    private static final Logger log = LoggerFactory.getLogger(PaymentConfirmationService.class);
    private static final String EMAIL_TEMPLATE_PATH = "email/email-template.html";
    private final TanRepository tanRepository;
    private final PsuRepository psuRepository;
    private final JavaMailSender emailSender;
    private final PaymentService paymentService;
    private final AccountService accountService;
    private final Configuration fmConfiguration;

    public boolean generateAndSendTanForPsuByIban(String iban) {
        return this.accountService.getPsuIdByIban(iban).map(arg_0 -> this.generateAndSendTanForPsu(arg_0)).orElse(false);
    }

    private boolean generateAndSendTanForPsu(String psuId) {
        return Optional.ofNullable(this.psuRepository.findOne((Serializable)((Object)psuId))).map(psu -> this.createAndSendTan(psu.getId(), psu.getEmail())).orElse(false);
    }

    public boolean isTanNumberValidByIban(String iban, String tanNumber, String consentId) {
        return this.accountService.getPsuIdByIban(iban).map(psuId -> this.isPsuTanNumberValid(psuId, tanNumber, consentId)).orElse(false);
    }

    private boolean isPsuTanNumberValid(String psuId, String tanNumber, String consentId) {
        boolean tanNumberValid = this.tanRepository.findByPsuIdAndTanStatus(psuId, TanStatus.UNUSED).stream().findFirst().map(t -> this.validateTanAndUpdateTanStatus(t, tanNumber)).orElse(false);
        if (!tanNumberValid) {
            this.paymentService.updatePaymentConsentStatus(consentId, SpiConsentStatus.REJECTED);
        }
        return tanNumberValid;
    }

    private boolean createAndSendTan(String psuId, String email) {
        this.changeOldTansToInvalid(psuId);
        Tan tan = new Tan(psuId, this.generateTanNumber());
        tan = (Tan)this.tanRepository.save((Object)tan);
        return this.sendTanNumberOnEmail(email, tan.getTanNumber());
    }

    private void changeOldTansToInvalid(String psuId) {
        List tans = this.tanRepository.findByPsuIdAndTanStatus(psuId, TanStatus.UNUSED);
        if (CollectionUtils.isNotEmpty((Collection)tans)) {
            for (Tan oldTan : tans) {
                oldTan.setTanStatus(TanStatus.INVALID);
            }
            this.tanRepository.save((Iterable)tans);
        }
    }

    private boolean validateTanAndUpdateTanStatus(Tan originalTan, String givenTanNumber) {
        boolean isValid = originalTan.getTanNumber().equals(givenTanNumber);
        if (isValid) {
            originalTan.setTanStatus(TanStatus.VALID);
        } else {
            originalTan.setTanStatus(TanStatus.INVALID);
        }
        this.tanRepository.save((Object)originalTan);
        return isValid;
    }

    private String generateTanNumber() {
        return RandomStringUtils.random((int)6, (boolean)true, (boolean)true);
    }

    private boolean sendTanNumberOnEmail(String email, String tanNumber) {
        if (this.emailSender == null) {
            log.warn("Email properties has not been set");
            return false;
        }
        MimeMessage mimeMessage = this.emailSender.createMimeMessage();
        try {
            MimeMessageHelper mail = new MimeMessageHelper(mimeMessage, true);
            mail.setSubject("Your TAN for payment confirmation");
            mail.setFrom(email);
            mail.setTo(email);
            mail.setText(this.getEmailContentFromTemplate(tanNumber), true);
            this.emailSender.send(mail.getMimeMessage());
            return true;
        }
        catch (MessagingException e) {
            log.warn("Problem with creating or sanding email: {}", (Throwable)e);
            return false;
        }
    }

    private String getEmailContentFromTemplate(String tanNumber) {
        StringBuilder content = new StringBuilder();
        try {
            Template emailTemplate = this.fmConfiguration.getTemplate(EMAIL_TEMPLATE_PATH);
            content.append(FreeMarkerTemplateUtils.processTemplateIntoString((Template)emailTemplate, Collections.singletonMap("tan", tanNumber)));
        }
        catch (Exception e) {
            log.warn("Problem with reading email template : {}", (Throwable)e);
            return "Your TAN number is " + tanNumber;
        }
        return content.toString();
    }

    @ConstructorProperties(value={"tanRepository", "psuRepository", "emailSender", "paymentService", "accountService", "fmConfiguration"})
    public PaymentConfirmationService(TanRepository tanRepository, PsuRepository psuRepository, JavaMailSender emailSender, PaymentService paymentService, AccountService accountService, Configuration fmConfiguration) {
        this.tanRepository = tanRepository;
        this.psuRepository = psuRepository;
        this.emailSender = emailSender;
        this.paymentService = paymentService;
        this.accountService = accountService;
        this.fmConfiguration = fmConfiguration;
    }
}

