/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.service.AccountService;
import de.adorsys.aspsp.aspspmockserver.service.PaymentService;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.aspsp.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.aspsp.xs2a.spi.domain.common.SpiAmount;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Currency;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class FutureBookingsService {
    private final AccountService accountService;
    private final PaymentService paymentService;

    public Optional<SpiAccountDetails> changeBalances(String iban, String currency) {
        return this.accountService.getAccountsByIban(iban).stream().filter(acc -> this.areCurrenciesEqual(acc.getCurrency(), currency)).findFirst().flatMap(arg_0 -> this.updateAccountBalance(arg_0));
    }

    private Optional<SpiAccountDetails> updateAccountBalance(SpiAccountDetails account) {
        return this.calculateNewBalance(account).flatMap(bal -> this.saveNewBalanceToAccount(account, bal));
    }

    private Optional<SpiAccountDetails> saveNewBalanceToAccount(SpiAccountDetails account, SpiAccountBalance balance) {
        account.updateFirstBalance(balance);
        return this.accountService.updateAccount(account);
    }

    private Optional<SpiAccountBalance> calculateNewBalance(SpiAccountDetails account) {
        return account.getFirstBalance().map(bal -> this.getNewBalance(account, bal));
    }

    private SpiAccountBalance getNewBalance(SpiAccountDetails account, SpiAccountBalance balance) {
        SpiAccountBalance newAccountBalance = new SpiAccountBalance();
        newAccountBalance.setSpiBalanceAmount(this.getNewAmount(account, balance));
        newAccountBalance.setLastChangeDateTime(LocalDateTime.now());
        newAccountBalance.setReferenceDate(LocalDate.now());
        return balance;
    }

    private SpiAmount getNewAmount(SpiAccountDetails account, SpiAccountBalance b) {
        return new SpiAmount(Currency.getInstance("EUR"), this.getNewBalanceAmount(account, b));
    }

    private BigDecimal getNewBalanceAmount(SpiAccountDetails account, SpiAccountBalance balance) {
        BigDecimal oldBalanceAmount = balance.getSpiBalanceAmount().getContent();
        return oldBalanceAmount.subtract(this.paymentService.calculateAmountToBeCharged(account.getId()));
    }

    private boolean areCurrenciesEqual(Currency accountCurrency, String givenCurrency) {
        return Optional.ofNullable(accountCurrency).map(curr -> curr.getCurrencyCode().equals(givenCurrency)).orElse(false);
    }

    @ConstructorProperties(value={"accountService", "paymentService"})
    public FutureBookingsService(AccountService accountService, PaymentService paymentService) {
        this.accountService = accountService;
        this.paymentService = paymentService;
    }
}

