/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.config.rest.consent;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ConsentRestConfig {
    @Value(value="${rest-consent-config.read-timeout.ms:10000}")
    private int readTimeout;
    @Value(value="${rest-consent-config.connection-timeout.ms:10000}")
    private int connectionTimeout;
    @Value(value="${consent-service.baseurl:http://localhost:38080/api/v1}")
    private String consentServiceBaseUrl;

    @Bean(name={"consentServiceBaseUrl"})
    public String consentServiceBaseUrl() {
        return this.consentServiceBaseUrl;
    }

    @Bean(name={"consentRestTemplate"})
    public RestTemplate consentRestTemplate() {
        RestTemplate rest = new RestTemplate(this.clientHttpRequestFactory());
        rest.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        rest.getMessageConverters().add(new StringHttpMessageConverter());
        return rest;
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectTimeout(this.connectionTimeout);
        return factory;
    }
}

