/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.config.email;

import de.adorsys.aspsp.aspspmockserver.config.email.EmailConfigurationProperties;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
public class EmailConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmailConfiguration.class);
    @Autowired
    private EmailConfigurationProperties emailConfigurationProperties;
    @Value(value="#{ new Boolean('${spring.mail.properties.mail.smtp.auth}') }")
    private boolean auth;
    @Value(value="#{ new Boolean('${spring.mail.properties.mail.smtp.starttls.enable}') }")
    private boolean isStarttlsEnable;

    @Bean
    public JavaMailSender javaMailSender() {
        if (this.isParametersExist()) {
            JavaMailSenderImpl sender = new JavaMailSenderImpl();
            sender.setHost(this.emailConfigurationProperties.getHost());
            sender.setPort(Integer.parseInt(this.emailConfigurationProperties.getPort()));
            sender.setUsername(this.emailConfigurationProperties.getUsername());
            sender.setPassword(this.emailConfigurationProperties.getPassword());
            sender.setJavaMailProperties(this.buildMailProperties());
            return sender;
        }
        log.warn("Email properties has not been set");
        return null;
    }

    private Properties buildMailProperties() {
        Properties props = new Properties();
        props.put("mail.smtp.auth", (Object)this.auth);
        props.put("mail.smtp.starttls.enable", (Object)this.isStarttlsEnable);
        return props;
    }

    private boolean isParametersExist() {
        return StringUtils.isNotBlank((CharSequence)this.emailConfigurationProperties.getHost()) && StringUtils.isNotBlank((CharSequence)this.emailConfigurationProperties.getPort()) && this.isAuthParametersExist();
    }

    private boolean isAuthParametersExist() {
        return !this.auth || StringUtils.isNotBlank((CharSequence)this.emailConfigurationProperties.getUsername()) && StringUtils.isNotBlank((CharSequence)this.emailConfigurationProperties.getPassword());
    }
}

