/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.amp.gcm.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import de.adorsys.amp.gcm.client.GCMException;
import de.adorsys.amp.gcm.client.GCMMessage;
import de.adorsys.amp.gcm.client.GCMResults;
import de.adorsys.amp.gcm.client.NotRegisteredException;
import de.adorsys.amp.gcm.client.UnknownRegistrationIdException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GCMService {
    static final Logger LOG = LoggerFactory.getLogger(GCMService.class);
    private HttpHost proxyHost;
    private com.mashape.unirest.http.ObjectMapper objectMapper;

    @PostConstruct
    public void postConstruct() {
        String proxyHostUrl = this.getEnv("GCM_PROXY_HOST");
        String proxyPort = this.getEnv("GCM_PROXY_PORT");
        if (proxyHostUrl != null) {
            this.proxyHost = proxyPort != null ? new HttpHost(proxyHostUrl, Integer.valueOf(proxyPort).intValue()) : new HttpHost(proxyHostUrl);
        }
        final ObjectMapper OM = new ObjectMapper();
        this.objectMapper = new com.mashape.unirest.http.ObjectMapper(){

            public String writeValue(Object value) {
                try {
                    return OM.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new GCMException("problem on serialization of " + value);
                }
            }

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)OM.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new GCMException("problem on deserialization of " + value);
                }
            }
        };
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)this.objectMapper);
    }

    public void sendNotification(GCMMessage.GCMNotification notification, Map<String, Object> data, String gcmApiKey, String ... registrationIds) throws UnknownRegistrationIdException, NotRegisteredException {
        GCMMessage gcmMessage = new GCMMessage();
        HashMap<String, String> converted = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            converted.put(entry.getKey(), this.objectMapper.writeValue(entry.getValue()));
        }
        gcmMessage.setData(converted);
        gcmMessage.setRegistrationIds(registrationIds);
        gcmMessage.setContentAvailable(true);
        gcmMessage.setPriority("high");
        gcmMessage.setNotification(notification);
        HttpPost httpPost = new HttpPost("https://gcm-http.googleapis.com/gcm/send");
        httpPost.addHeader("Authorization", "key=" + gcmApiKey);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.addHeader("accept", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValue((Object)gcmMessage), "UTF-8"));
        try (CloseableHttpClient httpClient = HttpClients.custom().setProxy(this.proxyHost).build();
             CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);){
            HttpResponse results = new HttpResponse((org.apache.http.HttpResponse)closeableHttpResponse, GCMResults.class);
            LOG.info(((GCMResults)results.getBody()).toString());
            List<GCMResults.GCMResult> resultList = ((GCMResults)results.getBody()).getResults();
            for (GCMResults.GCMResult gcmResult : resultList) {
                if ("InvalidRegistration".equals(gcmResult.getError())) {
                    throw new UnknownRegistrationIdException(registrationIds[0], gcmResult.getMessageId());
                }
                if (!"NotRegistered".equals(gcmResult.getError())) continue;
                throw new NotRegisteredException(registrationIds[0], gcmResult.getMessageId());
            }
        }
        catch (IOException e) {
            throw new GCMException("Connection problem sending GCM Message", e);
        }
    }

    private String getEnv(String prop) {
        String env = System.getenv(prop);
        if (env == null || env.trim().isEmpty()) {
            env = System.getProperty(prop);
        }
        return env;
    }
}

