/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.maven.i18n;

import de.acosix.maven.i18n.PropertiesLineReader;
import de.acosix.maven.i18n.ResourcesPluginUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="validateI18nResources", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class ValidateI18nResourcesMojo
extends AbstractMojo {
    private static final String PROPERTIES_EXTENSION = ".properties";
    protected static final List<String> DEFAULT_INCLUDES = Collections.unmodifiableList(Arrays.asList("**/*.properties"));
    @Parameter(defaultValue="${basedir}/src/main", readonly=true)
    protected File defaultValidationDirectory;
    @Parameter(defaultValue="${i18n.skip.validate}")
    protected boolean skip;
    @Parameter
    protected List<File> validationDirectories;
    @Parameter
    protected List<String> includes;
    @Parameter
    protected List<String> excludes;
    @Parameter
    protected List<String> requiredLocales;
    @Parameter(defaultValue="true")
    protected boolean reportMissingLocaleBundles;
    @Parameter(defaultValue="false")
    protected boolean failOnMissingLocaleBundles;
    @Parameter(defaultValue="true")
    protected boolean reportInconsistentMessageKeys;
    @Parameter(defaultValue="false")
    protected boolean failOnInconsistentMessageKeys;
    @Parameter(defaultValue="true")
    protected boolean reportEncodingIssues;
    @Parameter(defaultValue="true")
    protected boolean failOnEncodingIssues;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            Map<Locale, Map<String, File>> filesByBasePathByLocale = this.scanForPropertiesFiles();
            HashSet<Locale> allLocales = new HashSet<Locale>(filesByBasePathByLocale.keySet());
            TreeSet<String> allResourceBundleBasePaths = new TreeSet<String>();
            for (Map.Entry<Locale, Map<String, File>> filesByBasePath : filesByBasePathByLocale.entrySet()) {
                allResourceBundleBasePaths.addAll(filesByBasePath.getValue().keySet());
            }
            if (!allResourceBundleBasePaths.isEmpty()) {
                this.validateResourceBundles(filesByBasePathByLocale, allLocales, allResourceBundleBasePaths);
            } else {
                this.getLog().info((CharSequence)"Found no resource bundles to validate");
            }
        } else {
            this.getLog().info((CharSequence)"Skipping resource bundle validations");
        }
    }

    protected Map<Locale, Map<String, File>> scanForPropertiesFiles() {
        HashMap<Locale, Map<String, File>> filesByBasePathByLocale = new HashMap<Locale, Map<String, File>>(128);
        DirectoryScanner scanner = new DirectoryScanner();
        if (this.includes != null) {
            scanner.setIncludes(this.includes.toArray(new String[0]));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES.toArray(new String[0]));
        }
        if (this.excludes != null) {
            scanner.setExcludes(this.excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        if (this.validationDirectories == null) {
            this.validationDirectories = new ArrayList<File>();
        }
        if (this.validationDirectories.isEmpty()) {
            this.validationDirectories.add(this.defaultValidationDirectory);
        }
        for (File directory : this.validationDirectories) {
            if (!directory.exists()) continue;
            scanner.setBasedir(directory);
            scanner.scan();
            for (String includedFile : scanner.getIncludedFiles()) {
                if (!includedFile.endsWith(PROPERTIES_EXTENSION)) continue;
                String fileName = includedFile.indexOf(47) != -1 ? includedFile.substring(includedFile.lastIndexOf(47) + 1) : includedFile;
                String relativeBasePath = includedFile.indexOf(47) != -1 ? includedFile.substring(0, includedFile.lastIndexOf(47) + 1) : "";
                String fileBaseName = fileName.substring(0, fileName.length() - PROPERTIES_EXTENSION.length());
                StringBuilder localeBuilder = new StringBuilder();
                StringBuilder basePathBuilder = new StringBuilder(relativeBasePath);
                ResourcesPluginUtilities.extractBaseResourceNameAndLocaleFromFileName(fileBaseName, basePathBuilder, localeBuilder);
                String basePath = basePathBuilder.toString();
                Locale locale = localeBuilder.length() > 0 ? Locale.forLanguageTag(localeBuilder.toString()) : Locale.ROOT;
                HashMap<String, File> filesByBasePath = (HashMap<String, File>)filesByBasePathByLocale.get(locale);
                if (filesByBasePath == null) {
                    filesByBasePath = new HashMap<String, File>();
                    filesByBasePathByLocale.put(locale, filesByBasePath);
                }
                filesByBasePath.put(basePath, new File(directory, includedFile));
            }
        }
        return filesByBasePathByLocale;
    }

    protected void validateResourceBundles(Map<Locale, Map<String, File>> filesByBasePathByLocale, Collection<Locale> allLocales, Collection<String> allResourceBundleBasePaths) throws MojoFailureException, MojoExecutionException {
        ArrayList<Locale> requiredLocales = new ArrayList<Locale>();
        requiredLocales.add(Locale.ROOT);
        if (this.requiredLocales != null) {
            for (String locale : this.requiredLocales) {
                requiredLocales.add(Locale.forLanguageTag(locale));
            }
        }
        this.validateRequiredLocales(allResourceBundleBasePaths, requiredLocales, filesByBasePathByLocale);
        AtomicInteger missingLocaleBundles = new AtomicInteger(0);
        AtomicInteger inconsistentMessageKeys = new AtomicInteger(0);
        this.validateResourceBundles(allLocales, allResourceBundleBasePaths, filesByBasePathByLocale, missingLocaleBundles, inconsistentMessageKeys);
        if (this.failOnMissingLocaleBundles && missingLocaleBundles.get() > 0) {
            throw new MojoFailureException("Some resource bundles are only defined for a subset of locales");
        }
        if (this.failOnInconsistentMessageKeys && inconsistentMessageKeys.get() > 0) {
            throw new MojoFailureException("Some message bundles contain an inconsistent set of message keys");
        }
    }

    protected void validateRequiredLocales(Collection<String> allBasePaths, List<Locale> localesToValidate, Map<Locale, Map<String, File>> filesByBasePathAndLocale) throws MojoFailureException {
        boolean fail = false;
        for (Locale locale : localesToValidate) {
            String localeLabel = locale.equals(Locale.ROOT) ? "the default locale" : locale.toString();
            Map<String, File> localeFilesByBasePath = filesByBasePathAndLocale.get(locale);
            if (localeFilesByBasePath == null || localeFilesByBasePath.isEmpty()) {
                fail = true;
                for (String missingBasePath : allBasePaths) {
                    this.getLog().warn((CharSequence)(missingBasePath + " is missing a localised bundle for " + localeLabel));
                }
                this.getLog().error((CharSequence)(allBasePaths.size() + " resource bundle base paths have been found, but no resource bundles exist for " + localeLabel));
                continue;
            }
            TreeSet<String> missingBasePaths = new TreeSet<String>(allBasePaths);
            missingBasePaths.removeAll(localeFilesByBasePath.keySet());
            if (missingBasePaths.isEmpty()) continue;
            fail = true;
            for (String missingBasePath : missingBasePaths) {
                this.getLog().warn((CharSequence)(missingBasePath + " is missing a localised bundle for " + localeLabel));
            }
            this.getLog().error((CharSequence)(missingBasePaths.size() + " resource bundle(s) missing for " + localeLabel));
        }
        if (fail) {
            throw new MojoFailureException("Some of the required locales are missing specific resource bundles");
        }
    }

    protected void validateResourceBundles(Collection<Locale> allLocales, Collection<String> allBasePaths, Map<Locale, Map<String, File>> filesByBasePathAndLocale, AtomicInteger missingLocaleBundles, AtomicInteger inconsistentMessageKeys) throws MojoExecutionException, MojoFailureException {
        HashMap<Locale, String> localeLabels = new HashMap<Locale, String>();
        for (Locale locale : allLocales) {
            String localeLabel = locale.equals(Locale.ROOT) ? "the default locale" : locale.toString();
            localeLabels.put(locale, localeLabel);
        }
        if (this.reportEncodingIssues || this.failOnEncodingIssues) {
            AtomicInteger encodingIssues = new AtomicInteger(0);
            this.validateResourceBundleEncoding(allLocales, filesByBasePathAndLocale, encodingIssues, localeLabels);
            if (this.failOnEncodingIssues && encodingIssues.get() > 0) {
                throw new MojoFailureException("Some resource bundles contain non-ASCII characters or incorrect unicode escape sequences");
            }
        }
        for (String basePath : allBasePaths) {
            Map<Locale, ResourceBundle> bundles = this.loadBundlesForBasePath(basePath, allLocales, filesByBasePathAndLocale, missingLocaleBundles, localeLabels);
            if (!this.reportInconsistentMessageKeys && !this.failOnInconsistentMessageKeys) continue;
            this.validateResourceBundleConsistency(basePath, bundles, inconsistentMessageKeys, localeLabels);
        }
    }

    protected void validateResourceBundleEncoding(Collection<Locale> allLocales, Map<Locale, Map<String, File>> filesByBasePathAndLocale, AtomicInteger encodingIssues, Map<Locale, String> localeLabels) throws MojoExecutionException {
        Pattern nonAsciiCharacterPattern = Pattern.compile("[^\\x00-\\x7F]");
        Pattern invalidUnicodeEscapeSequencePattern = Pattern.compile("\\\\u(?![0-9a-fA-F]{4}).{4}");
        for (Locale locale : allLocales) {
            Map<String, File> filesByBasePath = filesByBasePathAndLocale.get(locale);
            for (Map.Entry<String, File> filesByBasePathEntry : filesByBasePath.entrySet()) {
                String basePath = filesByBasePathEntry.getKey();
                File file = filesByBasePathEntry.getValue();
                this.getLog().debug((CharSequence)("Reading properties file " + file));
                try {
                    BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.ISO_8859_1));
                    Throwable throwable = null;
                    try {
                        String logicalLine;
                        PropertiesLineReader lineReader = new PropertiesLineReader(bf);
                        int logicalLineNo = 0;
                        while ((logicalLine = lineReader.readLine()) != null) {
                            String logMessage;
                            ++logicalLineNo;
                            Matcher nonAsciiMatcher = nonAsciiCharacterPattern.matcher(logicalLine);
                            while (nonAsciiMatcher.find()) {
                                encodingIssues.incrementAndGet();
                                String character = nonAsciiMatcher.group();
                                logMessage = basePath + " for " + localeLabels.get(locale) + " contains non-ASCII character " + character + " in (logical) line no " + logicalLineNo;
                                if (this.failOnEncodingIssues) {
                                    this.getLog().error((CharSequence)logMessage);
                                    continue;
                                }
                                if (!this.reportEncodingIssues) continue;
                                this.getLog().warn((CharSequence)logMessage);
                            }
                            Matcher invalidUnicodeEscapeSequenceMatcher = invalidUnicodeEscapeSequencePattern.matcher(logicalLine);
                            while (invalidUnicodeEscapeSequenceMatcher.find()) {
                                encodingIssues.incrementAndGet();
                                logMessage = basePath + " for " + localeLabels.get(locale) + " contains ivalid unicode escape sequence " + invalidUnicodeEscapeSequenceMatcher.group() + " in (logical) line no " + logicalLineNo;
                                if (this.failOnEncodingIssues) {
                                    this.getLog().error((CharSequence)logMessage);
                                    continue;
                                }
                                if (!this.reportEncodingIssues) continue;
                                this.getLog().warn((CharSequence)logMessage);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bf == null) continue;
                        if (throwable != null) {
                            try {
                                bf.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        bf.close();
                    }
                }
                catch (IOException ioex) {
                    throw new MojoExecutionException("Failed to load file " + file, (Exception)ioex);
                }
            }
        }
    }

    protected void validateResourceBundleConsistency(String basePath, Map<Locale, ResourceBundle> bundles, AtomicInteger inconsistentMessageKeys, Map<Locale, String> localeLabels) {
        TreeSet<String> referenceKeys = new TreeSet<String>(bundles.get(Locale.ROOT).keySet());
        TreeSet<String> allKeys = new TreeSet<String>();
        for (ResourceBundle bundle : bundles.values()) {
            allKeys.addAll(bundle.keySet());
        }
        this.getLog().debug((CharSequence)(basePath + " defines " + allKeys.size() + " message key(s) across all its variants"));
        HashMap<String, ArrayList<Locale>> localesByMissingKeys = new HashMap<String, ArrayList<Locale>>();
        HashMap<String, ArrayList<Locale>> localesBySuperflousKeys = new HashMap<String, ArrayList<Locale>>();
        for (Map.Entry<Locale, ResourceBundle> entry : bundles.entrySet()) {
            Locale locale = entry.getKey();
            if (locale.equals(Locale.ROOT)) continue;
            ResourceBundle resourceBundle = entry.getValue();
            TreeSet<String> missingKeys = new TreeSet<String>((Collection<String>)referenceKeys);
            missingKeys.removeAll(resourceBundle.keySet());
            for (String missingKey : missingKeys) {
                ArrayList<Locale> locales = (ArrayList<Locale>)localesByMissingKeys.get(missingKey);
                if (locales == null) {
                    locales = new ArrayList<Locale>();
                    localesByMissingKeys.put(missingKey, locales);
                }
                locales.add(locale);
            }
            TreeSet<String> superflousKeys = new TreeSet<String>(resourceBundle.keySet());
            superflousKeys.removeAll(referenceKeys);
            for (String superflousKey : superflousKeys) {
                ArrayList<Locale> locales = (ArrayList<Locale>)localesBySuperflousKeys.get(superflousKey);
                if (locales == null) {
                    locales = new ArrayList<Locale>();
                    localesBySuperflousKeys.put(superflousKey, locales);
                }
                locales.add(locale);
            }
        }
        for (Map.Entry<Locale, ResourceBundle> entry : localesByMissingKeys.entrySet()) {
            this.logResourceBundleInconsistency(basePath, (String)((Object)entry.getKey()), true, (List)((Object)entry.getValue()));
            inconsistentMessageKeys.incrementAndGet();
        }
        for (Map.Entry<Locale, ResourceBundle> entry : localesBySuperflousKeys.entrySet()) {
            this.logResourceBundleInconsistency(basePath, (String)((Object)entry.getKey()), false, (List)((Object)entry.getValue()));
            inconsistentMessageKeys.incrementAndGet();
        }
    }

    protected Map<Locale, ResourceBundle> loadBundlesForBasePath(String basePath, Collection<Locale> allLocales, Map<Locale, Map<String, File>> filesByBasePathAndLocale, AtomicInteger missingLocaleBundles, Map<Locale, String> localeLabels) throws MojoExecutionException {
        HashMap<Locale, ResourceBundle> bundles = new HashMap<Locale, ResourceBundle>();
        for (Locale locale : allLocales) {
            Map<String, File> localeFilesByBasePath = filesByBasePathAndLocale.get(locale);
            if (localeFilesByBasePath != null && localeFilesByBasePath.containsKey(basePath)) {
                File file = localeFilesByBasePath.get(basePath);
                this.getLog().debug((CharSequence)("Reading bundle " + file));
                try {
                    FileInputStream is = new FileInputStream(file);
                    Throwable throwable = null;
                    try {
                        PropertyResourceBundle bundle = new PropertyResourceBundle(is);
                        bundles.put(locale, bundle);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        ((InputStream)is).close();
                        continue;
                    }
                }
                catch (IOException ioex) {
                    throw new MojoExecutionException("Failed to load resource bundle " + basePath + " for " + localeLabels.get(locale) + " from " + file, (Exception)ioex);
                }
                catch (IllegalArgumentException iaex) {
                    if (iaex.getMessage().contains("Malformed \\uxxxx encoding")) {
                        this.getLog().debug((CharSequence)("Resource bundle file " + file + " contains a malformed unicode escape sequence and cannot be loaded for validation"));
                        continue;
                    }
                    throw iaex;
                }
            }
            missingLocaleBundles.incrementAndGet();
            String message = basePath + " resource bundle is missing for " + localeLabels.get(locale);
            if (this.failOnMissingLocaleBundles) {
                this.getLog().error((CharSequence)message);
                continue;
            }
            if (!this.reportMissingLocaleBundles) continue;
            this.getLog().warn((CharSequence)message);
        }
        return bundles;
    }

    protected void logResourceBundleInconsistency(String basePath, String messageKey, boolean missing, List<Locale> locales) {
        StringBuilder messageBuilder = new StringBuilder(256);
        messageBuilder.append(basePath).append(" key ").append(messageKey).append(missing ? " defined in root bundle but not found in bundles for " : " not defined in root bundle but found in bundles for ");
        for (Locale locale : locales) {
            messageBuilder.append(locale).append(", ");
        }
        messageBuilder.delete(messageBuilder.length() - 2, messageBuilder.length());
        if (this.failOnInconsistentMessageKeys) {
            this.getLog().error((CharSequence)messageBuilder);
        } else if (this.reportInconsistentMessageKeys) {
            this.getLog().warn((CharSequence)messageBuilder);
        }
    }
}

