/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.maven.i18n;

public class ResourcesPluginUtilities {
    private static final String VARIANT_CODE_PATTERN = "^[a-zA-Z]+$";
    private static final String TWO_LETTER_CODE_PATTERN = "^[a-zA-Z]{2}$";

    private ResourcesPluginUtilities() {
    }

    protected static void extractBaseResourceNameAndLocaleFromFileName(String fileBaseName, StringBuilder resourceNameBuilder, StringBuilder localeBuilder) {
        String[] fragments = fileBaseName.split("_");
        int count = fragments.length;
        int localeStartIdx = -1;
        if (count > 3 && fragments[count - 1].matches(VARIANT_CODE_PATTERN) && fragments[count - 2].matches(TWO_LETTER_CODE_PATTERN) && fragments[count - 3].matches(TWO_LETTER_CODE_PATTERN)) {
            localeStartIdx = count - 3;
        } else if (count > 2 && fragments[count - 1].matches(TWO_LETTER_CODE_PATTERN) && fragments[count - 2].matches(TWO_LETTER_CODE_PATTERN)) {
            localeStartIdx = count - 2;
        } else if (count > 1 && fragments[count - 1].matches(TWO_LETTER_CODE_PATTERN)) {
            localeStartIdx = count - 1;
        }
        if (localeStartIdx != -1) {
            for (int idx = 0; idx < count; ++idx) {
                if (idx == 0) {
                    resourceNameBuilder.append(fragments[idx]);
                    continue;
                }
                if (idx < localeStartIdx) {
                    resourceNameBuilder.append('_').append(fragments[idx]);
                    continue;
                }
                if (idx == localeStartIdx) {
                    localeBuilder.append(fragments[idx]);
                    continue;
                }
                localeBuilder.append('_').append(fragments[idx]);
            }
        } else {
            resourceNameBuilder.append(fileBaseName);
        }
    }
}

