/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.maven.i18n;

import java.io.BufferedReader;
import java.io.IOException;

public class PropertiesLineReader {
    private final BufferedReader reader;
    private final boolean endReached = false;

    public PropertiesLineReader(BufferedReader reader) {
        this.reader = reader;
    }

    public String readLine() throws IOException {
        String lineFromFile;
        this.getClass();
        StringBuilder logicalLineBuilder = new StringBuilder();
        boolean isNewLine = true;
        boolean skipWhitespace = true;
        boolean skipEmptyLine = true;
        while ((lineFromFile = this.reader.readLine()) != null) {
            char lastChar;
            if (skipWhitespace && !lineFromFile.isEmpty()) {
                int lineStartIdx = 0;
                char c = lineFromFile.charAt(lineStartIdx);
                while ((c == ' ' || c == '\t' || c == '\f') && lineStartIdx + 1 < lineFromFile.length()) {
                    c = lineFromFile.charAt(++lineStartIdx);
                }
                if (c == ' ' || c == '\t' || c == '\f') {
                    lineFromFile = "";
                } else if (lineStartIdx > 0) {
                    lineFromFile = lineFromFile.substring(lineStartIdx);
                }
            }
            if (lineFromFile.isEmpty()) {
                if (!skipEmptyLine) break;
                continue;
            }
            if (isNewLine) {
                isNewLine = false;
                char firstChar = lineFromFile.charAt(0);
                if (firstChar == '#' || firstChar == '!') {
                    isNewLine = true;
                    continue;
                }
            }
            if ((lastChar = lineFromFile.charAt(lineFromFile.length() - 1)) != '\\') {
                logicalLineBuilder.append(lineFromFile);
                break;
            }
            logicalLineBuilder.append(lineFromFile.substring(0, lineFromFile.length() - 1));
            skipWhitespace = true;
            skipEmptyLine = false;
        }
        String result = logicalLineBuilder.length() > 0 ? logicalLineBuilder.toString() : null;
        return result;
    }
}

