/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.maven.i18n;

import de.acosix.maven.i18n.ResourcesPluginUtilities;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="duplicateI18nResources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class DuplicateI18nResourcesMojo
extends AbstractMojo {
    private static final String PROPERTIES_EXTENSION = ".properties";
    protected static final List<String> DEFAULT_INCLUDES = Collections.unmodifiableList(Arrays.asList("**/*.properties"));
    @Parameter(defaultValue="${i18n.skip.duplicate}")
    protected boolean skip;
    @Parameter(defaultValue="${basedir}/src/main", required=true)
    protected File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/i18n-resources", required=true)
    protected File outputDirectory;
    @Parameter
    protected List<String> includes;
    @Parameter
    protected List<String> excludes;
    @Parameter
    protected String sourceLocale;
    @Parameter(required=true)
    protected List<String> copyForLocales;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            Collection<String> propertyFileNames = this.getPropertyFileNamesToProcess();
            if (!propertyFileNames.isEmpty()) {
                for (String propertyFileName : propertyFileNames) {
                    if (!propertyFileName.endsWith(PROPERTIES_EXTENSION)) continue;
                    this.checkResourceBundleAndDuplicateIfNecessary(propertyFileName);
                }
            } else {
                this.getLog().info((CharSequence)"Found no resource bundles to process");
            }
        } else {
            this.getLog().info((CharSequence)"Skipping resource bundle duplication");
        }
    }

    protected void checkResourceBundleAndDuplicateIfNecessary(String propertyFileName) throws MojoExecutionException {
        String fileName = propertyFileName.indexOf(47) != -1 ? propertyFileName.substring(propertyFileName.lastIndexOf(47) + 1) : propertyFileName;
        String relativePath = propertyFileName.indexOf(47) != -1 ? propertyFileName.substring(0, propertyFileName.lastIndexOf(47) + 1) : "";
        String fileBaseName = fileName.substring(0, fileName.length() - PROPERTIES_EXTENSION.length());
        StringBuilder localeBuilder = new StringBuilder();
        StringBuilder resourceNameBuilder = new StringBuilder();
        ResourcesPluginUtilities.extractBaseResourceNameAndLocaleFromFileName(fileBaseName, resourceNameBuilder, localeBuilder);
        String resourceName = resourceNameBuilder.toString();
        if (this.sourceLocale == null && localeBuilder.length() == 0 || this.sourceLocale != null && this.sourceLocale.equals(localeBuilder.toString())) {
            for (String targetLocale : this.copyForLocales) {
                String targetResourceName = targetLocale.trim().length() > 0 ? MessageFormat.format("{0}_{1}", resourceName, targetLocale) : resourceName;
                String targetFileName = targetResourceName + PROPERTIES_EXTENSION;
                String targetPropertyFileName = relativePath + targetFileName;
                File sourceCandidate = new File(this.sourceDirectory, targetPropertyFileName);
                if (sourceCandidate.exists()) continue;
                File target = new File(this.outputDirectory, targetPropertyFileName);
                target.getParentFile().mkdirs();
                try {
                    FileUtils.copyFile((File)new File(this.sourceDirectory, propertyFileName), (File)target);
                }
                catch (IOException ioEx) {
                    throw new MojoExecutionException("Error copying resources", (Exception)ioEx);
                }
            }
        }
    }

    protected Collection<String> getPropertyFileNamesToProcess() {
        ArrayList<String> propertyFileNames = new ArrayList<String>();
        if (this.sourceDirectory.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.sourceDirectory);
            if (this.includes != null) {
                scanner.setIncludes(this.includes.toArray(new String[0]));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES.toArray(new String[0]));
            }
            if (this.excludes != null) {
                scanner.setExcludes(this.excludes.toArray(new String[0]));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            for (String includedFile : scanner.getIncludedFiles()) {
                propertyFileNames.add(includedFile);
            }
        }
        return propertyFileNames;
    }
}

