/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd.internal.worker;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkParameters;

public interface CpdWorkParameters
extends WorkParameters {
    public Property<String> getEncoding();

    public Property<Boolean> getIgnoreAnnotations();

    public Property<Boolean> getIgnoreFailures();

    public Property<Boolean> getIgnoreIdentifiers();

    public Property<Boolean> getIgnoreLiterals();

    public Property<String> getLanguage();

    public Property<Integer> getMinimumTokenCount();

    public Property<Boolean> getSkipBlocks();

    public Property<String> getSkipBlocksPattern();

    public Property<Boolean> getSkipDuplicateFiles();

    public Property<Boolean> getSkipLexicalErrors();

    public ConfigurableFileCollection getSourceFiles();

    public ListProperty<Report> getReportParameters();

    public static abstract class Report
    implements Serializable {
        private final String encoding;
        private final File destination;

        Report(String encoding, File destination) {
            this.encoding = encoding;
            this.destination = destination;
        }

        String getEncoding() {
            return this.encoding;
        }

        File getDestination() {
            return this.destination;
        }

        public static class Xml
        extends Report {
            public Xml(String encoding, File destination) {
                super(encoding, destination);
            }
        }

        public static class Text
        extends Report {
            private final String lineSeparator;
            private final boolean trimLeadingCommonSourceWhitespaces;

            public Text(String encoding, File destination, String lineSeparator, boolean trimLeadingCommonSourceWhitespaces) {
                super(encoding, destination);
                this.lineSeparator = lineSeparator;
                this.trimLeadingCommonSourceWhitespaces = trimLeadingCommonSourceWhitespaces;
            }

            String getLineSeparator() {
                return this.lineSeparator;
            }

            boolean getTrimLeadingCommonSourceWhitespaces() {
                return this.trimLeadingCommonSourceWhitespaces;
            }
        }

        public static class Csv
        extends Report {
            private final Character separator;

            public Csv(String encoding, File destination, Character separator) {
                super(encoding, destination);
                this.separator = separator;
            }

            Character getSeparator() {
                return this.separator;
            }
        }
    }
}

