/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd.internal.worker;

import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdWorkParameters;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

class CpdReporter {
    private static final Logger logger = Logging.getLogger(CpdReporter.class);

    CpdReporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generate(List<CpdWorkParameters.Report> reports, List<Match> matches) {
        if (logger.isInfoEnabled()) {
            logger.info("Generating reports");
        }
        for (CpdWorkParameters.Report report : reports) {
            CPDRenderer renderer = this.createRendererFor(report);
            try {
                FileWriter fileWriter = new FileWriter(report.getDestination());
                Throwable throwable = null;
                try {
                    ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        renderer.render(matches.iterator(), (Writer)fileWriter);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(previousContextClassLoader);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileWriter == null) continue;
                    if (throwable != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                throw new GradleException(e.getMessage(), (Throwable)e);
            }
        }
    }

    CPDRenderer createRendererFor(CpdWorkParameters.Report report) {
        if (report instanceof CpdWorkParameters.Report.Csv) {
            char separator = ((CpdWorkParameters.Report.Csv)report).getSeparator().charValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Creating renderer to generate CSV file separated by '{}'.", (Object)Character.valueOf(separator));
            }
            return new CSVRenderer(separator);
        }
        if (report instanceof CpdWorkParameters.Report.Text) {
            String lineSeparator = ((CpdWorkParameters.Report.Text)report).getLineSeparator();
            boolean trimLeadingCommonSourceWhitespaces = ((CpdWorkParameters.Report.Text)report).getTrimLeadingCommonSourceWhitespaces();
            if (logger.isDebugEnabled()) {
                logger.debug("Creating renderer to generate simple text file separated by '{}' and trimmed '{}'.", (Object)lineSeparator, (Object)trimLeadingCommonSourceWhitespaces);
            }
            SimpleRenderer result = new SimpleRenderer(lineSeparator);
            this.setTrimLeadingWhitespacesByReflection((CPDRenderer)result, trimLeadingCommonSourceWhitespaces);
            return result;
        }
        if (report instanceof CpdWorkParameters.Report.Xml) {
            String encoding = report.getEncoding();
            if (logger.isDebugEnabled()) {
                logger.debug("Creating XML renderer to generate with encoding '{}'.", (Object)encoding);
            }
            return new XMLRenderer(encoding);
        }
        throw new GradleException(String.format("Cannot create reports for unsupported type '%s'.", report.getClass()));
    }

    private void setTrimLeadingWhitespacesByReflection(CPDRenderer result, boolean trimLeadingCommonSourceWhitespaces) {
        block3: {
            String fieldName = "trimLeadingWhitespace";
            if (logger.isDebugEnabled()) {
                logger.debug("Try setting '{}' field to '{}' for '{}' by reflection.", new Object[]{fieldName, trimLeadingCommonSourceWhitespaces, result});
            }
            try {
                Field field = SimpleRenderer.class.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(result, trimLeadingCommonSourceWhitespaces);
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn(String.format("Could not set field '%s' on '%s' by reflection.", result.getClass(), fieldName), (Throwable)e);
            }
        }
    }
}

