/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd.internal.worker;

import java.io.File;
import java.io.Serializable;

public class CpdReportConfiguration
implements Serializable {
    private final String encoding;
    private final File destination;

    CpdReportConfiguration(String encoding, File destination) {
        this.encoding = encoding;
        this.destination = destination;
    }

    String getEncoding() {
        return this.encoding;
    }

    File getDestination() {
        return this.destination;
    }

    public static class CpdXmlReport
    extends CpdReportConfiguration {
        public CpdXmlReport(String encoding, File destination) {
            super(encoding, destination);
        }
    }

    public static class CpdTextReport
    extends CpdReportConfiguration {
        private final String lineSeparator;
        private final boolean trimLeadingCommonSourceWhitespaces;

        public CpdTextReport(String encoding, File destination, String lineSeparator, boolean trimLeadingCommonSourceWhitespaces) {
            super(encoding, destination);
            this.lineSeparator = lineSeparator;
            this.trimLeadingCommonSourceWhitespaces = trimLeadingCommonSourceWhitespaces;
        }

        String getLineSeparator() {
            return this.lineSeparator;
        }

        boolean getTrimLeadingCommonSourceWhitespaces() {
            return this.trimLeadingCommonSourceWhitespaces;
        }
    }

    public static class CpdCsvReport
    extends CpdReportConfiguration {
        private final Character separator;

        public CpdCsvReport(String encoding, File destination, Character separator) {
            super(encoding, destination);
            this.separator = separator;
        }

        Character getSeparator() {
            return this.separator;
        }
    }
}

