/*
 * Decompiled with CFR 0.152.
 */
package de.a9d3.testing.testdata;

import de.a9d3.testing.method_extractor.GetterIsSetterExtractor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Logger;

public class TestDataProvider {
    private static final Logger LOGGER = Logger.getLogger(TestDataProvider.class.getName());
    protected static final int LIST_ARRAY_ITEM_COUNT = 2;
    private Map<String, Function<String, Object>> providerMap = TestDataProvider.getDefaultProviderMap();

    public TestDataProvider() {
        this(Collections.emptyMap());
    }

    public TestDataProvider(Map<String, Function<String, Object>> customMap) {
        this.providerMap.putAll(customMap);
    }

    public static Map<String, Function<String, Object>> getDefaultProviderMap() {
        HashMap<String, Function<String, Object>> map = new HashMap<String, Function<String, Object>>();
        map.put(Boolean.TYPE.getName(), x -> x.hashCode() % 2 != 0);
        map.put(Boolean.class.getName(), (Function)map.get(Boolean.TYPE.getName()));
        map.put(Character.TYPE.getName(), x -> Character.valueOf((char)(x.hashCode() % 65535)));
        map.put(Character.class.getName(), (Function)map.get(Character.TYPE.getName()));
        map.put(Byte.TYPE.getName(), x -> (byte)(x.hashCode() % 255 - 127));
        map.put(Byte.class.getName(), (Function)map.get(Byte.TYPE.getName()));
        map.put(Short.TYPE.getName(), x -> (short)(x.hashCode() % 65535 - Short.MAX_VALUE));
        map.put(Short.class.getName(), (Function)map.get(Short.TYPE.getName()));
        map.put(Integer.TYPE.getName(), String::hashCode);
        map.put(Integer.class.getName(), (Function)map.get(Integer.TYPE.getName()));
        map.put(Long.TYPE.getName(), x -> (long)x.hashCode() << 16);
        map.put(Long.class.getName(), (Function)map.get(Long.TYPE.getName()));
        map.put(Float.TYPE.getName(), x -> Float.valueOf((float)x.hashCode() / 3.0f));
        map.put(Float.class.getName(), (Function)map.get(Float.TYPE.getName()));
        map.put(Double.TYPE.getName(), x -> (double)x.hashCode() * 2.0 / 3.0);
        map.put(Double.class.getName(), (Function)map.get(Double.TYPE.getName()));
        map.put(String.class.getName(), x -> UUID.nameUUIDFromBytes(x.getBytes()).toString());
        map.put(Instant.class.getName(), x -> Instant.ofEpochSecond(x.hashCode()));
        return map;
    }

    public <T> T fill(Class c, String seed, Boolean tryComplexConstructorIfPossible) {
        Function<String, Object> fun = this.providerMap.get(c.getName());
        if (fun != null) {
            return (T)fun.apply(seed);
        }
        LOGGER.finest("Could not find class in functionMap. Trying to invoke class by constructors.");
        return this.generateTestDataByNonStandardClass(c, seed, tryComplexConstructorIfPossible);
    }

    protected <T> T generateTestDataByNonStandardClass(Class c, String seed, Boolean complex) {
        if (Collection.class.isAssignableFrom(c)) {
            return (T)this.invokeCollectionInstance(c, seed);
        }
        if (Map.class.isAssignableFrom(c)) {
            return (T)this.invokeMapInstance(c, seed);
        }
        if (c.isArray()) {
            Object objects = Array.newInstance(c.getComponentType(), 2);
            for (int i = 0; i < Array.getLength(objects); ++i) {
                Array.set(objects, i, this.fill(c.getComponentType(), seed + i, false));
            }
            return (T)objects;
        }
        return this.resolveComplexObject(c, seed, complex);
    }

    private Collection invokeCollectionInstance(Class c, String seed) {
        Collection<Object> instance = c.equals(List.class) || c.equals(Queue.class) ? new LinkedList<Object>() : (c.equals(Set.class) ? new HashSet() : (Collection)this.resolveComplexObject(c, seed, false));
        for (int i = 0; i < 2; ++i) {
            instance.add(null);
        }
        return instance;
    }

    private Map invokeMapInstance(Class c, String seed) {
        Map<Object, Object> instance = null;
        if (!c.equals(SortedMap.class) && c.equals(Map.class)) {
            instance = new HashMap();
            instance.put(null, null);
        } else if (c.equals(SortedMap.class) || c.equals(TreeMap.class)) {
            instance = new TreeMap();
        } else {
            instance = (Map)this.resolveComplexObject(c, seed, false);
            instance.put(null, null);
        }
        return instance;
    }

    private <T> T resolveComplexObject(Class c, String seed, Boolean tryComplexConstructor) {
        Constructor<?>[] constructors = c.getConstructors();
        if (tryComplexConstructor.booleanValue()) {
            Arrays.sort(constructors, Comparator.comparingInt(con -> -con.getParameterCount()));
        } else {
            Arrays.sort(constructors, Comparator.comparingInt(Constructor::getParameterCount));
        }
        for (Constructor<?> single : constructors) {
            if (!Arrays.stream(single.getParameterTypes()).noneMatch(aClass -> aClass.equals(c))) continue;
            try {
                Object[] args = new Object[single.getParameterCount()];
                for (int i = 0; i < single.getParameterCount(); ++i) {
                    args[i] = this.fill(single.getParameterTypes()[i], seed + i, tryComplexConstructor);
                }
                if (args.length == 0) {
                    return (T)single.newInstance(new Object[0]);
                }
                return (T)single.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.fine("Could not initialize constructor " + single + " of class " + c.getName() + ". Trying other constructor if available.");
            }
        }
        StringBuilder message = new StringBuilder();
        message.append("Could not initialize ");
        message.append(c.getName());
        if (c.getConstructors().length == 0) {
            message.append("\nClass has no constructors.\nPlease refer to ");
            message.append("https://github.com/Mixermachine/base-test");
            message.append(" to get an idea how to use customMaps to initialize the TestDataProvider");
        }
        LOGGER.warning(message.toString());
        return null;
    }

    public <T> T fillMutableWithNull(Class c) throws IllegalAccessException, InvocationTargetException {
        T instance = this.fill(c, "123", false);
        for (Method method : GetterIsSetterExtractor.getSetter(c)) {
            if (method.getParameterTypes()[0].isPrimitive()) continue;
            method.invoke(instance, new Object[]{null});
        }
        return instance;
    }
}

