/*
 * Decompiled with CFR 0.152.
 */
package de.a9d3.testing.checker;

import de.a9d3.testing.checker.CheckerInterface;
import de.a9d3.testing.method_extractor.GetterIsSetterExtractor;
import de.a9d3.testing.testdata.TestDataProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;

public class HashcodeAndEqualsCheck
implements CheckerInterface {
    private TestDataProvider provider;

    public HashcodeAndEqualsCheck() {
        this(new TestDataProvider());
    }

    public HashcodeAndEqualsCheck(TestDataProvider provider) {
        this.provider = provider;
    }

    @Override
    public boolean check(Class c) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        List setterList = GetterIsSetterExtractor.getSetter(c).stream().filter(setter -> this.provider.fill(setter.getParameterTypes()[0], "123", false) != null).collect(Collectors.toList());
        Object a = c.newInstance();
        Object b = c.newInstance();
        int iter = 0;
        if (!this.haveEqualHashCode(c, a, b)) {
            return false;
        }
        for (Method mySetter : setterList) {
            this.executeSetter(mySetter, a, iter);
            if (this.areEqual(a, b) || this.haveEqualHashCode(c, a, b)) {
                return false;
            }
            this.executeSetter(mySetter, b, iter);
            if (!this.areEqual(a, b) || !this.haveEqualHashCode(c, a, b)) {
                return false;
            }
            ++iter;
        }
        return true;
    }

    private boolean areEqual(Object a, Object b) {
        return a.equals(b);
    }

    private boolean haveEqualHashCode(Class c, Object a, Object b) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method hashCode = c.getMethod("hashCode", new Class[0]);
        return hashCode.invoke(a, new Object[0]).equals(hashCode.invoke(b, new Object[0]));
    }

    private void executeSetter(Method m, Object o, int iter) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        m.invoke(o, this.provider.fill(m.getParameterTypes()[0], "f50c83cf-5b60-4b2b-a869-b99bb0d130b9" + iter, false));
    }
}

