/*
 * Decompiled with CFR 0.152.
 */
package de.a9d3.testing.checker;

import de.a9d3.testing.checker.CheckerInterface;
import de.a9d3.testing.method.GetterSetterMatcher;
import de.a9d3.testing.method.IsSetterMatcher;
import de.a9d3.testing.testdata.TestDataProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.stream.Stream;

public class DefensiveCopyingCheck
implements CheckerInterface {
    private TestDataProvider provider;

    public DefensiveCopyingCheck() {
        this(new TestDataProvider());
    }

    public DefensiveCopyingCheck(TestDataProvider provider) {
        this.provider = provider;
    }

    @Override
    public boolean check(Class c) {
        GetterSetterMatcher getterSetterMatcher = new GetterSetterMatcher();
        IsSetterMatcher isSetterMatcher = new IsSetterMatcher();
        return Stream.concat(getterSetterMatcher.match(c).stream(), isSetterMatcher.match(c).stream()).noneMatch(tuple -> {
            try {
                Class<?> myC = tuple.getA().getReturnType();
                if (myC.isPrimitive() || this.isPrimitiveWrapper(myC) || this.isString(myC)) {
                    return false;
                }
                Object a = this.provider.fill(c, "123", false);
                Object data = this.provider.fill(tuple.getA().getReturnType(), "824a5189-0014-4d64-a7bd-89f921ab8de2", false);
                tuple.getB().invoke(a, data);
                return data == tuple.getA().invoke(a, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return true;
            }
        });
    }

    private boolean isPrimitiveWrapper(Class c) {
        return c == Double.class || c == Float.class || c == Long.class || c == Integer.class || c == Short.class || c == Character.class || c == Byte.class || c == Boolean.class;
    }

    private boolean isString(Class c) {
        return c == String.class;
    }
}

