package de.fiveminds.client.utility;

import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow.Subscriber;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class DynamicBodyPublisher implements BodyPublisher {
	private static final Logger logger = Logger.getLogger("DynamicBodyPublisher");
	private static final ObjectMapper objectMapper = new ObjectMapper();
	private final BodyPublisher stringPublisher;
	
	public DynamicBodyPublisher(Object objectToMap) {
		if (objectToMap == null) {
			stringPublisher = BodyPublishers.ofString("{}");
			return;
		}
		
		try {
			String mappedObject = objectMapper.writeValueAsString(objectToMap);
			logger.log(Level.FINE, "Publishing json: ", mappedObject);
			stringPublisher = BodyPublishers.ofString(mappedObject);
		} catch (JsonProcessingException e) {
			throw new RuntimeException("An error occurred while serializing the object of type " + objectToMap.getClass().getName() + " to json.", e);
		}
	}
	
	@Override
	public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
		this.stringPublisher.subscribe(subscriber);
	}
	
	@Override
	public long contentLength() {
		return this.stringPublisher.contentLength();
	}
}
