package de.fiveminds.client.types;

public class SocketSettings {
	public static final String namespace = "api";

	public static class MessagePaths {
		  public static final String activityError = "OnActivityError";
		  public static final String activityReached = "activity_reached";
		  public static final String activityFinished = "activity_finished";
		  public static final String activityCanceled = "activity_canceled";
		  public static final String boundaryEventWaiting = "boundary_event_waiting";
		  public static final String boundaryEventTriggered = "boundary_event_triggered";
		  public static final String boundaryEventFinished = "boundary_event_finished";
		  public static final String callActivityReceivedResponse = "OnFlowNodeCallActivityResponseReceived";
		  public static final String correlationMetadataChanged = "correlation_metadata_changed";
		  public static final String cronjobCreated = "cronjob_created";
		  public static final String cronjobExecuted = "cronjob_executed";
		  public static final String cronjobEnabledChanged = "cronjob_enabled_changed";
		  public static final String cronjobRemoved = "cronjob_removed";
		  public static final String cronjobStopped = "cronjob_stopped";
		  public static final String cronjobUpdated = "cronjob_updated";
		  public static final String emptyActivityWaiting = "empty_activity_waiting";
		  public static final String emptyActivityFinished = "empty_activity_finished";
		  public static final String untypedTaskWaiting = "untyped_task_waiting";
		  public static final String untypedTaskFinished = "untyped_task_finished";
		  public static final String endEventFinished = "end_event_finished";
		  public static final String externalTaskCreated = "external_task_created";
		  public static final String externalTaskLocked = "external_task_locked";
		  public static final String externalTaskUnlocked = "external_task_unlocked";
		  public static final String externalTaskExpired = "external_task_expired";
		  public static final String flowNodeEntered = "OnFlowNodeEntered";
		  public static final String flowNodeExit = "OnFlowNodeExited";
		  public static final String flowNodeSuspended = "OnFlowNodeSuspended";
		  public static final String flowNodeResumed = "OnFlowNodeResumed";
		  public static final String flowNodeError = "OnFlowNodeError";
		  public static final String flowNodeTerminated = "OnFlowNodeTerminated";
		  public static final String flowNodeTimerStarted = "OnFlowNodeTimerStarted";
		  public static final String flowNodeTimerRemoved = "OnFlowNodeTimerRemoved";
		  public static final String gatewayFinished = "OnGatewayFinished";
		  public static final String intermediateThrowEventTriggered = "intermediate_throw_event_triggered";
		  public static final String intermediateCatchEventReached = "intermediate_catch_event_reached";
		  public static final String intermediateCatchEventFinished = "intermediate_catch_event_finished";
		  public static final String flowNodeEventRetrySending = "flow_node_event_retry_sending";
		  public static final String manualTaskWaiting = "manual_task_waiting";
		  public static final String manualTaskFinished = "manual_task_finished";
		  public static final String messageTriggered = "message_triggered";
		  public static final String processDeployed = "process_deployed";
		  public static final String processExecutableChanged = "process_executable_changed";
		  // ----
		  // TODO - These notifications should be named OnProcessInstance*; to better separate them from the ProcessModel related notifications.
		  // Since that is a breaking change; this should be done with the next major update.
		  public static final String processStarting = "OnProcessStarting";
		  public static final String processStarted = "OnProcessStarted";
		  public static final String processResumed = "OnProcessResumed";
		  public static final String processEnded = "OnProcessFinished";
		  public static final String processError = "OnProcessError";
		  public static final String processTerminated = "OnProcessTerminated";
		  // ----
		  public static final String processInstanceOwnerChanged = "process_instance_owner_changed";
		  public static final String processInstanceMetadataChanged = "process_instance_metadata_changed";
		  public static final String processInstancesDeleted = "OnProcessInstancesDeleted";
		  public static final String processUndeployed = "process_undeployed";
		  public static final String sendTaskSendMessage = "OnFlowNodeEventSending";
		  public static final String sendTaskSendMessageRetry = "OnFlowNodeEventRetrySending";
		  public static final String sendTaskReceivedResponse = "OnFlowNodeEventResponseReceived";
		  public static final String signalTriggered = "signal_triggered";
		  public static final String startEventFinished = "start_event_finished";
		  public static final String userTaskWaiting = "user_task_waiting";
		  public static final String userTaskFinished = "user_task_finished";
		  public static final String userTaskReserved = "user_task_reserved";
		  public static final String userTaskReservationCanceled = "user_task_reservation_canceled";
	}
}
