package de.fiveminds.client.processModel.model.constants;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BpmnType {
	untypedTask("bpmn:Task"),
	businessRuleTask("bpmn:BusinessRuleTask"),
	userTask("bpmn:UserTask"),
	exclusiveGateway("bpmn:ExclusiveGateway"),
	parallelGateway("bpmn:ParallelGateway"),
	serviceTask("bpmn:ServiceTask"),
	startEvent("bpmn:StartEvent"),
	endEvent("bpmn:EndEvent"),
	intermediateCatchEvent("bpmn:IntermediateCatchEvent"),
	intermediateThrowEvent("bpmn:IntermediateThrowEvent"),
	scriptTask("bpmn:ScriptTask"),
	boundaryEvent("bpmn:BoundaryEvent"),
	callActivity("bpmn:CallActivity"),
	subProcess("bpmn:SubProcess"),
	manualTask("bpmn:ManualTask"),
	complexGateway("bpmn:ComplexGateway"),
	inclusiveGateway("bpmn:InclusiveGateway"),
	eventBasedGateway("bpmn:EventBasedGateway"),
	sendTask("bpmn:SendTask"),
	receiveTask("bpmn:ReceiveTask");
	
	public final String value;
	private final static Map<String, BpmnType> CONSTANTS = new HashMap<String, BpmnType>();
	
	static {
		for (BpmnType bpmnType : values()) {
			CONSTANTS.put(bpmnType.value, bpmnType);
		}
	}
	
	private BpmnType(String value) {
		this.value = value;
	}
	
	@JsonValue
	public String value() {
		return this.value;
	}
	
	@JsonCreator
	public static BpmnType fromValue(String value) {
		BpmnType bpmnType = CONSTANTS.get(value);
	
		if (bpmnType == null && value != null) {
			throw new IllegalArgumentException("Cannot deserialize BpmnType from value " + value + ".");
		}
		
		return bpmnType;
	}
}
