package de.fiveminds.client.extensionAdapter;

import java.util.concurrent.CompletableFuture;

import de.fiveminds.client.dataModels.iam.Identity;
import de.fiveminds.client.dataModels.processDefinitions.ProcessDefinition.ProcessModel;
import de.fiveminds.client.dataModels.processDefinitions.ProcessDefinition.ProcessModelList;
import de.fiveminds.client.dataModels.processInstance.ProcessStartOptions;
import de.fiveminds.client.dataModels.processInstance.ProcessStartResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

public interface IProcessModelExtensionAdapter {
	public CompletableFuture<ProcessModelList> getAll(ProcessModelQueryOptions options);
	
	public CompletableFuture<ProcessModel> getById(@NonNull String processModelId, Identity identity);
	
	public CompletableFuture<ProcessModel> getByProcessInstanceId(@NonNull String processInstanceId, Identity identity);
	
	public <TPayload> CompletableFuture<ProcessStartResponse> startProcessInstance(@NonNull ProcessStartOptions<TPayload> options, Identity identity);
	
	public <TPayload> CompletableFuture<ProcessStartResponse> startProcessInstanceAndAwaitEndEvent(@NonNull ProcessStartOptions<TPayload> options, Identity identity);
	
	public <TPayload> CompletableFuture<ProcessStartResponse> startProcessInstanceAndAwaitSpecificEndEvent(@NonNull ProcessStartOptions<TPayload> options, @NonNull String endEventId, Identity identity);
	
	public CompletableFuture<Void> deleteDefinitionByProcessModelId(@NonNull String processModelId, DeleteDefinitionByProcessModelIdOptions options);
	
	public CompletableFuture<Void> enableProcessModel(@NonNull String processModelId, Identity identity);
	
	public CompletableFuture<Void> disableProcessModel(@NonNull String processModelId, Identity identity);
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class ProcessModelQueryOptions {
		private Identity identity;
		
		@Builder.Default private Integer offset = 0;
		
		@Builder.Default private Integer limit = 0;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class DeleteDefinitionByProcessModelIdOptions {
		private Boolean force;
		
		private Identity identity;
		
		private Boolean deleteAllRelatedData;
	}
}
