package de.fiveminds.client.dataModels.processInstance;

import java.util.Date;
import java.util.HashMap;

import javax.swing.event.DocumentEvent.EventType;

import de.fiveminds.client.dataModels.Correlation;
import de.fiveminds.client.dataModels.flowNodeInstance.FlowNodeInstance;
import de.fiveminds.client.processModel.model.events.errorEvents.Error;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
/**
 * A ProcessInstance.
 */
public class ProcessInstance {
	/**
	 * The id of the correlation in which context the process instance runs.
	 */
	@NonNull private String correlationId;
	
	/**
	 * The id of the process instance.
	 */
	@NonNull private String processInstanceId;
	
	/**
	 * The id of the process definition which the process instance belongs to.
	 */
	@NonNull private String processDefinitionId;
	
	/**
	 * The id of the executed process model.
	 */
	@NonNull private String processModelId;
	
	/**
	 * The name of the executed process model.
	 */
	private String processModelName;
	
	/**
	 * The version of the executed process model.
	 */
	private String processModelVersion;
	
	/**
	 * The id of the parent process instance, if this process instance is a sub process.
	 */
	private String parentProcessInstanceId;
	
	/**
	 * The hash of the used process model.
	 */
	@NonNull private String hash;
	
	/**
	 * The xml of the used process model.
	 */
	private String xml;
	
	/**
	 * The state of the process instance.
	 */
	@NonNull private ProcessInstanceState state;
	
	/**
	 * The error that occurred during execution of the process instance (if any).
	 */
	@NonNull private Error error;
	
	/**
	 * The id of the user who started the process instance.
	 */
	@NonNull private String ownerId;
	
	/**
	 * The id of the anonymous session that started the process instance (if any).
	 */
	private String anonymousSessionId;
	
	/**
	 * A flag indicating whether or not the process instance was started using a root access token.
	 */
	private boolean startedByRootAccessToken;
	
	/**
	 * The date when the process instance was started.
	 */
	private Date createdAt;
	
	/**
	 * The date when the process instance was finished.
	 */
	private Date finishedAt;
	
	/**
	 * The date when the process instance was restarted (if any).
	 */
	private Date restartedAt;
	
	/**
	 * The id of the user who terminated the process instance (if any).
	 */
	private String terminatedByUserId;
	
	/**
	 * The duration of the process instance in milliseconds.
	 */
	private Integer durationInMilliseconds;
	
	/**
	 * The id of the start event that started the process instance.
	 */
	private String startEventId;
	
	/**
	 * The type of the start event that started the process instance.
	 */
	private EventType startEventType;
	
	/**
	 * The token that was used to start the process instance
	 */
	private Object startToken;
	
	/**
	 * The id of the end event that ended the process instance (if ended).
	 */
	private String endEventId;
	
	/**
	 * The type of the end event that ended the process instance (if ended).
	 */
	private EventType endEventType;
	
	/**
	 * The token that reached the end event (if ended).
	 */
	private Object endToken;
	
	/**
	 * The metadata of the process instance.
	 */
	private ProcessInstanceMetadata metadata;
	
	/**
	 * The correlation in which context the process instance runs.
	 */
	private Correlation correlation;
	
	/**
	 * The FlowNodeInstance that triggered the process instance (if any).
	 */
	private FlowNodeInstance triggeredByFlowNodeInstance;
	
	/**
	 * Describes a Metadata property of a ProcessInstance.
	 */
	public static class ProcessInstanceMetadata extends HashMap<String, String> {

		private static final long serialVersionUID = -1416868884222750258L;

	}
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class ProcessInstanceList {
		private ProcessInstance[] processInstances;
		
		private int totalCount;
	}
	
	/**
	 * Lists the various states that a ProcessInstance can be in.
	 */
	public static enum ProcessInstanceState {
		running,
		finished,
		error,
		terminated
	}
}
