package de.fiveminds.client.dataModels.processDefinitions;

import java.util.Date;
import java.util.HashMap;

import de.fiveminds.client.dataModels.processModel.model.processElements.LaneSet;
import de.fiveminds.client.dataModels.processModel.viewModel.FlowNodeViewModel;
import de.fiveminds.client.dataModels.processModel.viewModel.events.EndEventViewModel;
import de.fiveminds.client.dataModels.processModel.viewModel.events.StartEventViewModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
/**
 * A ProcessDefinition.
 */
public class ProcessDefinition {
	/**
	 * The ID of the ProcessDefinition.
	 */
	@NonNull private String processDefinitionId;
	
	/**
	 * The XML of the ProcessDefinition.
	 */
	@NonNull private String xml;
	
	/**
	 * The hash of the ProcessDefinition.
	 */
	@NonNull private String hash;
	
	/**
	 * The ProcessModels contained in the ProcessDefinition.
	 */
	@NonNull private ProcessModel[] processModels;
	
	/**
	 * The date when the ProcessDefinition was deployed.
	 */
	@NonNull private Date deployedAt;
	
	/**
	 * The ID of the user who deployed the ProcessDefinition.
	 */
	@NonNull private String deployedByUserId;
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	/**
	 * A list of ProcessDefinitions.
	 */
	public static class ProcessDefinitionList {
		/**
		 * The ProcessDefinitions.
		 */
		@NonNull private ProcessDefinition[] processDefinitions;
		
		/**
		 * The total number of ProcessDefinitions.
		 */
		private int totalCount;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	/**
	 * A ProcessModel.
	 */
	public static class ProcessModel {
		/**
		 * The ID of the ProcessDefinition that contains the ProcessModel.
		 */
		@NonNull private String processDefinitionId;
		
		/**
		 * The ID of the ProcessModel.
		 */
		@NonNull private String processModelId;
		
		/**
		 * The name of the ProcessModel.
		 */
		private String processModelName;
		
		/**
		 * The version of the ProcessModel.
		 */
		private String version;
		
		private HashMap<String, Object> customProperties;
		
		/**
		 * A flag indicating whether the ProcessModel can be started.
		 */
		@NonNull private Boolean isExecutable;
		
		private LaneSet laneSet;
		
		/**
		 * The StartEvents contained in the ProcessModel.
		 */
		@NonNull private StartEventViewModel[] startEvents;
		
		/**
		 * The EndEvents contained in the ProcessModel.
		 */
		@NonNull private EndEventViewModel[] endEvents;
		
		/**
		 * The FlowNodes contained in the ProcessModel.
		 */
		@NonNull private FlowNodeViewModel[] flowNodes;
	}
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	/**
	 * A list of ProcessModels.
	 */
	public static class ProcessModelList {
		/**
		 * The ProcessModels.
		 */
		@NonNull private ProcessModel[] processModels;
		
		/**
		 * The total number of ProcessModels.
		 */
		private int totalCount;
	}
	
	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	/**
	 * The payload for persisting process definitions.
	 */
	public static class PersistProcessDefinitionsPayload {
		/**
		 * The xml of the process definition(s) to persist.
		 */
		@NonNull private String xml; // TODO: This could also be a String[]
		
		/**
		 * A flag indicating whether existing process definitions should be overwritten.
		 */
		private Boolean overwriteExisting;
	}
}
