package de.fiveminds.client.dataModels.externalTasks;

import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
/**
 * Describes an ExternalTask that the Engine has delegated to an
 * ExternalTask worker for processing.
 */
public class ExternalTask<TPayload> {
	/**
	 * The ID of the ExternalTask.
	 */
	@NonNull private String id;
	
	/**
	 * The ID of the worker that has most recently locked the ExternalTask
	 * for processing.
	 */
	@NonNull private String workerId;
	
	/**
	 * The topic of the ExternalTask.
	 */
	@NonNull private String topic;
	
	/**
	 * A flag indicating whether or not the ExternalTask is a single try task.
	 */
	@NonNull private Boolean isSingleTry;
	
	/**
	 * The ID of the FlowNodeInstance that the ExternalTask belongs to.
	 */
	@NonNull private String flowNodeInstanceId;
	
	/**
	 * The ID of the Correlation that the ExternalTask belongs to.
	 */
	@NonNull private String correlationId;
	
	/**
	 * The ID of the ProcessDefinition that contains the ExternalTask.
	 */
	@NonNull private String processDefinitionId;
	
	/**
	 * The ID of the ProcessModel that contains the ExternalTask.
	 */
	private String processModelId;
	
	/**
	 * The ID of the SubProcess that contains the ExternalTask.
	 */
	private String embeddedProcessModelId;
	
	/**
	 * The ID of the ProcessInstance the ExternalTask belongs to.
	 */
	@NonNull private String processInstanceId;
	
	/**
	 * The ID of the user that owns the ExternalTask.
	 */
	@NonNull private String ownerId;
	
	/**
	 * The payload containing all relevant data the worker needs to execute the
	 * ExternalTask.
	 */
	@NonNull private TPayload payload;
	
	/**
	 * The lock expiration time. On expiration, the task is released to
	 * be processed by other workers.
	 * If not set, the ExternalTask is not locked.
	 */
	@NonNull private Date lockExpirationTime;
	
	/**
	 * The state of the ExternalTask.
	 */
	@NonNull ExternalTaskState state;
	
	/**
	 * The date when the ExternalTask was finished.
	 */
	private Date finishedAt;
	
	/**
	 * The result of the ExternalTask.
	 */
	private Object result;
	
	/**
	 * The error that occurred during processing of the ExternalTask (if any).
	 */
	private Object error;
	
	/**
	 * The date when the ExternalTask was created.
	 */
	private Date createdAt;
	
	public static enum ExternalTaskState {
		pending,
		finished,
		expired
	}
}
