package de.fiveminds.client.clients;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.function.Function;

import de.fiveminds.client.Client;
import de.fiveminds.client.ExternalTaskWorker;
import de.fiveminds.client.dataModels.externalTasks.ExternalTask;
import de.fiveminds.client.dataModels.iam.Identity;
import de.fiveminds.client.types.ExternalTaskWorkerConfig;
import de.fiveminds.client.types.HandleExternalTaskAction;
import de.fiveminds.client.utility.AbortController.AbortSignal;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NonNull;

@AllArgsConstructor
public class ExternalTaskHttpClient {
	@Getter
	@NonNull private URI engineUrl;
	@NonNull private Identity identity = Client.dummyIdentity;
	
	public <TExternalTaskPayload, TResultPayload, TExternalTask extends ExternalTask<TExternalTaskPayload>> ExternalTaskWorker<TExternalTaskPayload, TResultPayload, TExternalTask> subscribeToExternalTaskTopic(
	@NonNull String topic,
	@NonNull Function<TExternalTaskPayload, TResultPayload> processingFunction,
	ExternalTaskWorkerConfig config,
	@NonNull Class<TExternalTask[]> externalTaskArrayClass) {
		ExternalTaskWorkerConfig extendedConfig = config == null 
				? new ExternalTaskWorkerConfig() 
						: ExternalTaskWorkerConfig.builder()
				.identity(config.getIdentity() == null ? this.identity : config.getIdentity())
				.lockDuration(config.getLockDuration())
				.longpollingTimeout(config.getLongpollingTimeout())
				.maxTasks(config.getMaxTasks())
				.payloadFilter(config.getPayloadFilter())
				.workerId(config.getWorkerId())
				.build();
		try {
			return new ExternalTaskWorker<TExternalTaskPayload, TResultPayload, TExternalTask>(
					engineUrl,
					UUID.randomUUID().toString(),
					0,
					topic,
					new HandleExternalTaskAction<TExternalTaskPayload, TResultPayload>() {

						@Override
						public TResultPayload run(TExternalTaskPayload payload, ExternalTask<TExternalTaskPayload> externalTask,
								AbortSignal abortSignal) {
							if (abortSignal.isAborted()) {
								throw new RuntimeException(abortSignal.getException());
							}
							return processingFunction.apply(payload);
						}
					},
					extendedConfig,
					externalTaskArrayClass);
		} catch (UnknownHostException | URISyntaxException error) {
			throw new RuntimeException("Could not subscribe to External Task Topic: ", error);
		}
	}
}
