package de.fiveminds.client.clients;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import de.fiveminds.client.InternalHttpClient.RequestOptions;
import de.fiveminds.client.dataModels.ApplicationInfo;
import de.fiveminds.client.dataModels.iam.Identity;
import de.fiveminds.client.extensionAdapter.IApplicationInfoExtensionAdapter;
import de.fiveminds.client.lib.SocketIoManager;
import de.fiveminds.client.types.RestSettings;
import lombok.NonNull;

public class ApplicationInfoHttpClient extends BaseClient implements IApplicationInfoExtensionAdapter {
	public ApplicationInfoHttpClient(@NonNull URI engineUrl, @NonNull Identity identity, SocketIoManager socketIoManager) throws UnknownHostException, URISyntaxException {
		super(engineUrl, identity, socketIoManager);
	}
	
	@Override
	public CompletableFuture<ApplicationInfo> getApplicationInfo() {
		List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
		
		URI url = this.buildUrl(RestSettings.Paths.getApplicationInfo, 0, 0, null, null);

		CompletableFuture<HttpResponse<ApplicationInfo>> httpResponse = this.httpClient.get(
				url,
				RequestOptions.builder()
					.headers(requestAuthHeaders)
					.build(),
				ApplicationInfo.class);
		
		return httpResponse.<ApplicationInfo>thenApply((HttpResponse<ApplicationInfo> result) -> result.body());
	}

	@Override
	public CompletableFuture<URI> getAuthorityAddress() {
		List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
		
		URI url = this.buildUrl(RestSettings.Paths.getAuthorityAddress, 0, 0, null, null);
		
		CompletableFuture<HttpResponse<URI>> httpResponse = this.httpClient.get(
				url,
				RequestOptions.builder()
					.headers(requestAuthHeaders)
					.build(),
				URI.class);
		
		return httpResponse.<URI>thenApply((HttpResponse<URI> result) -> result.body());
	}

//  TODO: Fix SocketIoManager
//	public Subscription onConnected(Listener callback, Boolean subscribeOnce, Identity identity) throws UnauthorizedError, URISyntaxException {
//		return this.createSocketIoSubscription("connect", callback, subscribeOnce, identity);
//	}
//
//	public Subscription onDisconnected(Listener callback, Boolean subscribeOnce, Identity identity) throws UnauthorizedError, URISyntaxException {
//		return this.createSocketIoSubscription("disconnect", callback, subscribeOnce, identity);
//	}
//
//	public Subscription onReconnected(Listener callback, Boolean subscribeOnce, Identity identity) throws UnauthorizedError, URISyntaxException {
//		return this.createSocketIoSubscription("reconnect", callback, subscribeOnce, identity);
//	}

}
