/*
 * Decompiled with CFR 0.152.
 */
package de.fiveminds.client.utility;

import java.net.URI;
import java.net.URISyntaxException;
import lombok.NonNull;

public class UriUtils {
    @NonNull
    public static URI replaceInUri(@NonNull URI url, String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return new URI(scheme == null ? url.getScheme() : scheme, authority == null ? url.getAuthority() : authority, path == null ? url.getPath() : path, query == null ? url.getQuery() : query, fragment == null ? url.getFragment() : fragment);
    }

    @NonNull
    public static URI extendPath(@NonNull URI url, String pathSegment) throws URISyntaxException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (pathSegment == null) {
            return url;
        }
        Object path = url.getPath();
        if (path != null && !((String)path).endsWith("/") && !pathSegment.startsWith("/")) {
            path = (String)path + "/";
        }
        path = (String)path + pathSegment;
        return UriUtils.replaceInUri(url, null, null, (String)path, null, null);
    }
}

