/*
 * Decompiled with CFR 0.152.
 */
package de.fiveminds.client.utility;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;

public class DynamicBodyPublisher
implements HttpRequest.BodyPublisher {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpRequest.BodyPublisher stringPublisher;

    public DynamicBodyPublisher(Object objectToMap) {
        if (objectToMap == null) {
            this.stringPublisher = HttpRequest.BodyPublishers.ofString("{}");
            return;
        }
        try {
            String mappedObject = objectMapper.writeValueAsString(objectToMap);
            System.out.println(mappedObject);
            this.stringPublisher = HttpRequest.BodyPublishers.ofString(mappedObject);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Uncaught", e);
        }
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        this.stringPublisher.subscribe(subscriber);
    }

    @Override
    public long contentLength() {
        return this.stringPublisher.contentLength();
    }
}

