/*
 * Decompiled with CFR 0.152.
 */
package de.fiveminds.client.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fiveminds.client.errors.ClientErrors;
import de.fiveminds.client.errors.ErrorCodes;
import de.fiveminds.client.errors.InformationErrors;
import de.fiveminds.client.errors.RedirectErrors;
import de.fiveminds.client.errors.ServerErrors;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public class BaseError
extends RuntimeException {
    @NonNull
    public ErrorCodes code;
    public String additionalInformation;
    public ErrorCategory category;
    public boolean fatal;
    String callStack;
    public boolean isEngineError;

    public BaseError(@NonNull ErrorCodes code, @NonNull String message, ErrorCategory category) {
        super(BaseError.setCategoryPrefix(message, category));
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.code = code;
        this.category = category;
    }

    @JsonCreator
    public static BaseError deserialize(String value) {
        BaseError errorClass;
        boolean structureIsIncorrect;
        Map errorInfo;
        try {
            errorInfo = (Map)new ObjectMapper().readValue(value, ErrorInfo.class);
        }
        catch (Exception error) {
            throw new RuntimeException("Error while deserializing error: Couldn't parse string: " + error.getMessage(), error);
        }
        boolean errorClassUndefined = !errorInfo.containsKey("errorClassName");
        boolean codeUndefined = !errorInfo.containsKey("code");
        boolean callStackUndefined = !errorInfo.containsKey("callStack");
        boolean errorTypeUndefined = !errorInfo.containsKey("errorType");
        boolean bl = structureIsIncorrect = errorClassUndefined || codeUndefined || callStackUndefined || errorTypeUndefined;
        if (structureIsIncorrect) {
            throw new RuntimeException("Error while deserializing error: Serialized object has an incompatible structure.");
        }
        try {
            errorClass = BaseError.instanciateError((String)errorInfo.get("errorClassName"), (String)errorInfo.get("message"));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException error) {
            throw new RuntimeException("Error while deserializing error: Couldn't create instance of class: " + errorInfo.get("errorClassName"), error);
        }
        errorClass.setCallStack((String)errorInfo.get("callStack"));
        errorClass.setAdditionalInformation(errorInfo.getOrDefault("additionalInformation", null));
        return errorClass;
    }

    @JsonValue
    public String serialize() throws IllegalArgumentException, IllegalAccessException, JsonProcessingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorClassName", this.getClass().getSimpleName());
        map.put("code", (Object)this.code);
        map.put("message", this.getMessage());
        map.put("callStack", this.getStackTrace());
        map.put("additionalInformation", this.additionalInformation);
        map.put("errorType", "Error");
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.putIfAbsent(field.getName(), field.get(this));
        }
        return new ObjectMapper().writeValueAsString(map);
    }

    private static BaseError instanciateError(@NonNull String errorClassName, @NonNull String message) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (errorClassName == null) {
            throw new NullPointerException("errorClassName is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        HashMap errorClasses = new HashMap();
        for (Class<?> errorClass : ClientErrors.class.getClasses()) {
            errorClasses.put(errorClass.getSimpleName(), errorClass);
        }
        for (Class<?> errorClass : InformationErrors.class.getClasses()) {
            errorClasses.put(errorClass.getSimpleName(), errorClass);
        }
        for (Class<?> errorClass : RedirectErrors.class.getClasses()) {
            errorClasses.put(errorClass.getSimpleName(), errorClass);
        }
        for (Class<?> errorClass : ServerErrors.class.getClasses()) {
            errorClasses.put(errorClass.getSimpleName(), errorClass);
        }
        if (!errorClasses.containsKey(errorClassName)) {
            throw new RuntimeException("Error while deserializing error: " + errorClassName + " is not a known error type.");
        }
        Class errorClass = (Class)errorClasses.get(errorClassName);
        Constructor errorConstructor = errorClass.getConstructor(String.class, ErrorCategory.class);
        Object error = errorConstructor.newInstance(message, null);
        return (BaseError)error;
    }

    private static String setCategoryPrefix(@NonNull String message, ErrorCategory category) {
        boolean messageIncludesCategoryAlready;
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        boolean bl = messageIncludesCategoryAlready = category == null || message.startsWith("Failure in " + category);
        if (messageIncludesCategoryAlready) {
            return message;
        }
        return "Failure in " + category + ": " + message;
    }

    public static boolean isEngineError(Exception error) {
        if (error instanceof BaseError) {
            return ((BaseError)error).isEngineError();
        }
        return false;
    }

    @Generated
    private static boolean $default$fatal() {
        return false;
    }

    @Generated
    private static boolean $default$isEngineError() {
        return true;
    }

    @Generated
    public static BaseErrorBuilder builder() {
        return new BaseErrorBuilder();
    }

    @NonNull
    @Generated
    public ErrorCodes getCode() {
        return this.code;
    }

    @Generated
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Generated
    public ErrorCategory getCategory() {
        return this.category;
    }

    @Generated
    public boolean isFatal() {
        return this.fatal;
    }

    @Generated
    public String getCallStack() {
        return this.callStack;
    }

    @Generated
    public boolean isEngineError() {
        return this.isEngineError;
    }

    @Generated
    public void setCode(@NonNull ErrorCodes code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        this.code = code;
    }

    @Generated
    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    @Generated
    public void setCategory(ErrorCategory category) {
        this.category = category;
    }

    @Generated
    public void setFatal(boolean fatal) {
        this.fatal = fatal;
    }

    @Generated
    public void setCallStack(String callStack) {
        this.callStack = callStack;
    }

    @Generated
    public void setEngineError(boolean isEngineError) {
        this.isEngineError = isEngineError;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseError)) {
            return false;
        }
        BaseError other = (BaseError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFatal() != other.isFatal()) {
            return false;
        }
        if (this.isEngineError() != other.isEngineError()) {
            return false;
        }
        ErrorCodes this$code = this.getCode();
        ErrorCodes other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)((Object)this$code)).equals((Object)other$code)) {
            return false;
        }
        String this$additionalInformation = this.getAdditionalInformation();
        String other$additionalInformation = other.getAdditionalInformation();
        if (this$additionalInformation == null ? other$additionalInformation != null : !this$additionalInformation.equals(other$additionalInformation)) {
            return false;
        }
        ErrorCategory this$category = this.getCategory();
        ErrorCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        String this$callStack = this.getCallStack();
        String other$callStack = other.getCallStack();
        return !(this$callStack == null ? other$callStack != null : !this$callStack.equals(other$callStack));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseError;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFatal() ? 79 : 97);
        result = result * 59 + (this.isEngineError() ? 79 : 97);
        ErrorCodes $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)((Object)$code)).hashCode());
        String $additionalInformation = this.getAdditionalInformation();
        result = result * 59 + ($additionalInformation == null ? 43 : $additionalInformation.hashCode());
        ErrorCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        String $callStack = this.getCallStack();
        result = result * 59 + ($callStack == null ? 43 : $callStack.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BaseError(code=" + this.getCode() + ", additionalInformation=" + this.getAdditionalInformation() + ", category=" + this.getCategory() + ", fatal=" + this.isFatal() + ", callStack=" + this.getCallStack() + ", isEngineError=" + this.isEngineError() + ")";
    }

    @Generated
    public BaseError(@NonNull ErrorCodes code, String additionalInformation, ErrorCategory category, boolean fatal, String callStack, boolean isEngineError) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        this.code = code;
        this.additionalInformation = additionalInformation;
        this.category = category;
        this.fatal = fatal;
        this.callStack = callStack;
        this.isEngineError = isEngineError;
    }

    @Generated
    public BaseError() {
        this.fatal = BaseError.$default$fatal();
        this.isEngineError = BaseError.$default$isEngineError();
    }

    @Generated
    public static class BaseErrorBuilder {
        @Generated
        private ErrorCodes code;
        @Generated
        private String additionalInformation;
        @Generated
        private ErrorCategory category;
        @Generated
        private boolean fatal$set;
        @Generated
        private boolean fatal$value;
        @Generated
        private String callStack;
        @Generated
        private boolean isEngineError$set;
        @Generated
        private boolean isEngineError$value;

        @Generated
        BaseErrorBuilder() {
        }

        @Generated
        public BaseErrorBuilder code(@NonNull ErrorCodes code) {
            if (code == null) {
                throw new NullPointerException("code is marked non-null but is null");
            }
            this.code = code;
            return this;
        }

        @Generated
        public BaseErrorBuilder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        @Generated
        public BaseErrorBuilder category(ErrorCategory category) {
            this.category = category;
            return this;
        }

        @Generated
        public BaseErrorBuilder fatal(boolean fatal) {
            this.fatal$value = fatal;
            this.fatal$set = true;
            return this;
        }

        @Generated
        public BaseErrorBuilder callStack(String callStack) {
            this.callStack = callStack;
            return this;
        }

        @Generated
        public BaseErrorBuilder isEngineError(boolean isEngineError) {
            this.isEngineError$value = isEngineError;
            this.isEngineError$set = true;
            return this;
        }

        @Generated
        public BaseError build() {
            boolean fatal$value = this.fatal$value;
            if (!this.fatal$set) {
                fatal$value = BaseError.$default$fatal();
            }
            boolean isEngineError$value = this.isEngineError$value;
            if (!this.isEngineError$set) {
                isEngineError$value = BaseError.$default$isEngineError();
            }
            return new BaseError(this.code, this.additionalInformation, this.category, fatal$value, this.callStack, isEngineError$value);
        }

        @Generated
        public String toString() {
            return "BaseError.BaseErrorBuilder(code=" + this.code + ", additionalInformation=" + this.additionalInformation + ", category=" + this.category + ", fatal$value=" + this.fatal$value + ", callStack=" + this.callStack + ", isEngineError$value=" + this.isEngineError$value + ")";
        }
    }

    public static enum ErrorCategory {
        process,
        setup,
        extension;

    }

    private static class ErrorInfo
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -451083304472905964L;

        private ErrorInfo() {
        }
    }
}

