/*
 * Decompiled with CFR 0.152.
 */
package de.fiveminds.client.clients;

import de.fiveminds.client.InternalHttpClient;
import de.fiveminds.client.clients.BaseClient;
import de.fiveminds.client.dataModels.iam.Identity;
import de.fiveminds.client.dataModels.processDefinitions.ProcessDefinition;
import de.fiveminds.client.dataModels.processInstance.ProcessStartOptions;
import de.fiveminds.client.dataModels.processInstance.ProcessStartResponse;
import de.fiveminds.client.extensionAdapter.IProcessModelExtensionAdapter;
import de.fiveminds.client.lib.SocketIoManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class ProcessModelHttpClient
extends BaseClient
implements IProcessModelExtensionAdapter {
    public ProcessModelHttpClient(@NonNull URI engineUrl, @NonNull Identity identity, SocketIoManager socketIoManager) throws UnknownHostException, URISyntaxException {
        super(engineUrl, identity, socketIoManager);
        if (engineUrl == null) {
            throw new NullPointerException("engineUrl is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    @Override
    public CompletableFuture<ProcessDefinition.ProcessModelList> getAll(IProcessModelExtensionAdapter.ProcessModelQueryOptions options) {
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
        URI url = this.buildUrl("/process_models", options == null ? 0 : options.getOffset(), options == null ? 0 : options.getLimit(), null, null);
        CompletableFuture<HttpResponse<ProcessDefinition.ProcessModelList>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ProcessDefinition.ProcessModelList.class);
        return httpResponse.thenApply(httpResult -> (ProcessDefinition.ProcessModelList)httpResult.body());
    }

    @Override
    public CompletableFuture<ProcessDefinition.ProcessModel> getById(@NonNull String processModelId, Identity identity) {
        if (processModelId == null) {
            throw new NullPointerException("processModelId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_models/:process_model_id/".replace(":process_model_id", processModelId), 0, 0, null, null);
        CompletableFuture<HttpResponse<ProcessDefinition.ProcessModel>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ProcessDefinition.ProcessModel.class);
        return httpResponse.thenApply(httpResult -> (ProcessDefinition.ProcessModel)httpResult.body());
    }

    @Override
    public CompletableFuture<ProcessDefinition.ProcessModel> getByProcessInstanceId(@NonNull String processInstanceId, Identity identity) {
        if (processInstanceId == null) {
            throw new NullPointerException("processInstanceId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_instances/:process_instance_id/process_model".replace(":process_instance_id", processInstanceId), 0, 0, null, null);
        CompletableFuture<HttpResponse<ProcessDefinition.ProcessModel>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ProcessDefinition.ProcessModel.class);
        return httpResponse.thenApply(httpResult -> (ProcessDefinition.ProcessModel)httpResult.body());
    }

    @Override
    public <TPayload> CompletableFuture<ProcessStartResponse> startProcessInstance(@NonNull ProcessStartOptions<TPayload> options, Identity identity) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_models/:process_model_id/start".replace(":process_model_id", options.getProcessModelId()), 0, 0, null, null);
        ProcessStartOptions.ProcessStartRequest<TPayload> body = new ProcessStartOptions.ProcessStartRequest<TPayload>(ProcessStartOptions.StartCallbackType.CallbackOnProcessInstanceCreated, null);
        body.setCorrelationId(options.getCorrelationId());
        body.setInitialToken(options.getInitialToken());
        body.setProcessModelId(options.getProcessModelId());
        body.setStartEventId(options.getStartEventId());
        CompletableFuture<HttpResponse<ProcessStartResponse>> httpResponse = this.httpClient.post(url, body, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ProcessStartResponse.class);
        return httpResponse.thenApply(httpResult -> (ProcessStartResponse)httpResult.body());
    }

    @Override
    public <TPayload> CompletableFuture<ProcessStartResponse> startProcessInstanceAndAwaitEndEvent(@NonNull ProcessStartOptions<TPayload> options, Identity identity) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_models/:process_model_id/start".replace(":process_model_id", options.getProcessModelId()), 0, 0, null, null);
        ProcessStartOptions.ProcessStartRequest<TPayload> body = new ProcessStartOptions.ProcessStartRequest<TPayload>(ProcessStartOptions.StartCallbackType.CallbackOnProcessInstanceFinished, null);
        body.setCorrelationId(options.getCorrelationId());
        body.setInitialToken(options.getInitialToken());
        body.setProcessModelId(options.getProcessModelId());
        body.setStartEventId(options.getStartEventId());
        CompletableFuture<HttpResponse<ProcessStartResponse>> httpResponse = this.httpClient.post(url, body, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ProcessStartResponse.class);
        return httpResponse.thenApply(httpResult -> (ProcessStartResponse)httpResult.body());
    }

    @Override
    public <TPayload> CompletableFuture<ProcessStartResponse> startProcessInstanceAndAwaitSpecificEndEvent(@NonNull ProcessStartOptions<TPayload> options, @NonNull String endEventId, Identity identity) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (endEventId == null) {
            throw new NullPointerException("endEventId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_models/:process_model_id/start".replace(":process_model_id", options.getProcessModelId()), 0, 0, null, null);
        ProcessStartOptions.ProcessStartRequest<TPayload> body = new ProcessStartOptions.ProcessStartRequest<TPayload>(ProcessStartOptions.StartCallbackType.CallbackOnEndEventReached, endEventId);
        body.setCorrelationId(options.getCorrelationId());
        body.setInitialToken(options.getInitialToken());
        body.setProcessModelId(options.getProcessModelId());
        body.setStartEventId(options.getStartEventId());
        CompletableFuture<HttpResponse<ProcessStartResponse>> httpResponse = this.httpClient.post(url, body, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), ProcessStartResponse.class);
        return httpResponse.thenApply(httpResult -> (ProcessStartResponse)httpResult.body());
    }

    @Override
    public CompletableFuture<Void> deleteDefinitionByProcessModelId(@NonNull String processModelId, IProcessModelExtensionAdapter.DeleteDefinitionByProcessModelIdOptions options) {
        if (processModelId == null) {
            throw new NullPointerException("processModelId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(this.identity);
        URI url = this.buildUrl("/process_models/:process_model_id".replace(":process_model_id", processModelId), 0, 0, null, null);
        if (options != null && options.getForce() != null) {
            url = this.addParameterToUrl(url, "force", options.getForce());
        }
        if (options != null && options.getDeleteAllRelatedData() != null) {
            url = this.addParameterToUrl(url, "delete_all_related_data", options.getDeleteAllRelatedData());
        }
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.delete(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(httpResult -> (Void)httpResult.body());
    }

    @Override
    public CompletableFuture<Void> enableProcessModel(@NonNull String processModelId, Identity identity) {
        if (processModelId == null) {
            throw new NullPointerException("processModelId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_models/:process_model_id/enable".replace(":process_model_id", processModelId), 0, 0, null, null);
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.post(url, null, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(httpResult -> (Void)httpResult.body());
    }

    @Override
    public CompletableFuture<Void> disableProcessModel(@NonNull String processModelId, Identity identity) {
        if (processModelId == null) {
            throw new NullPointerException("processModelId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/process_models/:process_model_id/disable".replace(":process_model_id", processModelId), 0, 0, null, null);
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.post(url, null, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(httpResult -> (Void)httpResult.body());
    }
}

