/*
 * Decompiled with CFR 0.152.
 */
package de.fiveminds.client.clients;

import de.fiveminds.client.InternalHttpClient;
import de.fiveminds.client.clients.BaseClient;
import de.fiveminds.client.dataModels.externalTasks.ExternalTask;
import de.fiveminds.client.dataModels.externalTasks.ExternalTaskError;
import de.fiveminds.client.dataModels.externalTasks.ExternalTaskRequestPayloads;
import de.fiveminds.client.dataModels.iam.Identity;
import de.fiveminds.client.extensionAdapter.IExternalTaskExtensionAdapter;
import de.fiveminds.client.lib.SocketIoManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import lombok.NonNull;

public class ExternalTaskApiHttpClient
extends BaseClient
implements IExternalTaskExtensionAdapter {
    public ExternalTaskApiHttpClient(@NonNull URI engineUrl, @NonNull Identity identity, SocketIoManager socketIoManager) throws UnknownHostException, URISyntaxException {
        super(engineUrl, identity, socketIoManager);
        if (engineUrl == null) {
            throw new NullPointerException("engineUrl is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
    }

    @Override
    public CompletableFuture<String[]> getAllDeployedTopics(Identity identity) {
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/external_tasks/deployed_topics", 0, 0, null, null);
        CompletableFuture<HttpResponse<String[]>> httpResponse = this.httpClient.get(url, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), String[].class);
        return httpResponse.thenApply(result -> (String[])result.body());
    }

    @Override
    public <TPayload, TExternalTask extends ExternalTask<TPayload>> CompletableFuture<ExternalTask<TPayload>[]> fetchAndLockExternalTasks(@NonNull String workerId, @NonNull String[] topicNames, int maxTasks, int longPollingTimeout, int lockDuration, Pattern payloadFilter, Identity identity, @NonNull Class<TExternalTask[]> externalTaskWithPayloadClass) {
        if (workerId == null) {
            throw new NullPointerException("workerId is marked non-null but is null");
        }
        if (topicNames == null) {
            throw new NullPointerException("topicNames is marked non-null but is null");
        }
        if (externalTaskWithPayloadClass == null) {
            throw new NullPointerException("externalTaskWithPayloadClass is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/external_tasks/fetch_and_lock", 0, 0, null, null);
        ExternalTaskRequestPayloads.FetchAndLockRequestPayload body = ExternalTaskRequestPayloads.FetchAndLockRequestPayload.builder().workerId(workerId).topicName(topicNames).maxTasks(maxTasks).longPollingTimeout(longPollingTimeout).lockDuration(lockDuration).payloadFilter(payloadFilter == null ? "/.*/" : payloadFilter.pattern()).build();
        CompletableFuture<HttpResponse<TExternalTask[]>> httpResponse = this.httpClient.post(url, body, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), externalTaskWithPayloadClass);
        return httpResponse.thenApply(result -> (ExternalTask[])result.body());
    }

    @Override
    public CompletableFuture<Void> extendLock(@NonNull String workerId, @NonNull String externalTaskId, int additionalDuration, Identity identity) {
        if (workerId == null) {
            throw new NullPointerException("workerId is marked non-null but is null");
        }
        if (externalTaskId == null) {
            throw new NullPointerException("externalTaskId is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/external_tasks/:external_task_id/extend_lock".replace(":external_task_id", externalTaskId), 0, 0, null, null);
        ExternalTaskRequestPayloads.ExtendLockRequestPayload body = ExternalTaskRequestPayloads.ExtendLockRequestPayload.builder().workerId(workerId).additionalDuration(additionalDuration).build();
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.put(url, body, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(result -> (Void)result.body());
    }

    @Override
    public CompletableFuture<Void> handleError(@NonNull String workerId, @NonNull String externalTaskId, @NonNull ExternalTaskError error, Identity identity) {
        if (workerId == null) {
            throw new NullPointerException("workerId is marked non-null but is null");
        }
        if (externalTaskId == null) {
            throw new NullPointerException("externalTaskId is marked non-null but is null");
        }
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/external_tasks/:external_task_id/error".replace(":external_task_id", externalTaskId), 0, 0, null, null);
        ExternalTaskRequestPayloads.HandleExternalTaskErrorRequestPayload body = ExternalTaskRequestPayloads.HandleExternalTaskErrorRequestPayload.builder().workerId(workerId).error(error).build();
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.put(url, body, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(result -> (Void)result.body());
    }

    @Override
    public <TResultType> CompletableFuture<Void> finishExternalTask(@NonNull String workerId, @NonNull String externalTaskId, @NonNull TResultType result, Identity identity) {
        if (workerId == null) {
            throw new NullPointerException("workerId is marked non-null but is null");
        }
        if (externalTaskId == null) {
            throw new NullPointerException("externalTaskId is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        List<String> requestAuthHeaders = this.createRequestAuthHeaders(identity);
        URI url = this.buildUrl("/external_tasks/:external_task_id/finish".replace(":external_task_id", externalTaskId), 0, 0, null, null);
        ExternalTaskRequestPayloads.FinishExternalTaskRequestPayload<TResultType> body = new ExternalTaskRequestPayloads.FinishExternalTaskRequestPayload<TResultType>();
        body.setWorkerId(workerId);
        body.setResult(result);
        CompletableFuture<HttpResponse<Void>> httpResponse = this.httpClient.put(url, body, InternalHttpClient.RequestOptions.builder().headers(requestAuthHeaders).build(), Void.class);
        return httpResponse.thenApply(httpResult -> (Void)httpResult.body());
    }
}

