/*
 * Decompiled with CFR 0.152.
 */
package de.fiveminds.client.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fiveminds.client.InternalHttpClient;
import de.fiveminds.client.clients.IBaseClient;
import de.fiveminds.client.dataModels.iam.Identity;
import de.fiveminds.client.engineEvents.Subscription;
import de.fiveminds.client.errors.UnauthorizedError;
import de.fiveminds.client.lib.SocketIoManager;
import de.fiveminds.client.utility.UriUtils;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import lombok.NonNull;

public class BaseClient
implements IBaseClient {
    private final URI baseUrl;
    private final URI engineUrl;
    public final Identity identity;
    protected InternalHttpClient httpClient;
    protected SocketIoManager socketIoManager;

    protected BaseClient(@NonNull URI engineUrl, @NonNull Identity identity, SocketIoManager socketIoManager) throws UnknownHostException, URISyntaxException {
        if (engineUrl == null) {
            throw new NullPointerException("engineUrl is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        this.engineUrl = engineUrl;
        this.identity = identity;
        this.socketIoManager = socketIoManager;
        this.baseUrl = UriUtils.extendPath(engineUrl, "atlas_engine/api/v1");
        this.httpClient = new InternalHttpClient(engineUrl);
    }

    @Override
    public boolean connected() {
        if (this.socketIoManager == null) {
            return true;
        }
        Socket socketIoClient = this.socketIoManager.getSocketForIdentity(this.identity);
        return socketIoClient == null ? false : socketIoClient.connected();
    }

    @Override
    public URI getEngineUrl() {
        return this.engineUrl;
    }

    @Override
    public boolean isSocketConnected(Identity identity) {
        Identity identityToUse = identity == null ? this.identity : identity;
        Socket socketIoClient = this.socketIoManager.getSocketForIdentity(identityToUse);
        return socketIoClient == null ? false : socketIoClient.connected();
    }

    @Override
    public void disconnectSocket(@NonNull Identity identity) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (this.socketIoManager == null) {
            return;
        }
        this.socketIoManager.disconnectSocket(identity);
    }

    @Override
    public void close() throws Exception {
        if (this.socketIoManager == null) {
            return;
        }
        this.socketIoManager.close();
    }

    @NonNull
    protected <TQuery, TSort> URI buildUrl(@NonNull String url, int offset, int limit, TQuery query, TSort sortSettings) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        URI finalUrl = this.baseUrl;
        try {
            if (finalUrl.getScheme() == null) {
                finalUrl = UriUtils.replaceInUri(finalUrl, "http", null, null, null, null);
            }
            finalUrl = UriUtils.extendPath(finalUrl, url);
            if (query != null) {
                finalUrl = this.encodeQueryAndAddParametersToUrl(finalUrl, query);
            }
            if (sortSettings != null) {
                String jsonString = new ObjectMapper().writeValueAsString(sortSettings);
                String encodedSortSettings = this.encodeURIComponent(jsonString);
                finalUrl = this.addParameterToUrl(finalUrl, "sortSettings", encodedSortSettings);
            }
            if (offset > 0) {
                finalUrl = this.addParameterToUrl(finalUrl, "offset", offset);
            }
            if (limit > 0) {
                finalUrl = this.addParameterToUrl(finalUrl, "limit", limit);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build url: ", e);
        }
        return finalUrl;
    }

    protected List<String> createRequestAuthHeaders(Identity identity) {
        Identity identityToUse = identity == null ? this.identity : identity;
        LinkedList<String> requestAuthHeaders = new LinkedList<String>();
        requestAuthHeaders.add("Authorization");
        requestAuthHeaders.add("Bearer " + identityToUse.getToken());
        if (identityToUse.getAnonymousSessionId() != null) {
            requestAuthHeaders.add("anonymous-session-id");
            requestAuthHeaders.add(identityToUse.getAnonymousSessionId());
        }
        if (identityToUse.getUserId() != null) {
            requestAuthHeaders.add("user-id");
            requestAuthHeaders.add(identityToUse.getUserId());
        }
        return requestAuthHeaders;
    }

    @NonNull
    protected Subscription createSocketIoSubscription(@NonNull String route, @NonNull Emitter.Listener callback, Boolean subscribeOnce, Identity identity) throws UnauthorizedError, URISyntaxException {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        Identity identityToUse = identity == null ? this.identity : identity;
        return this.socketIoManager.createSocketIoSubscription(identityToUse, route, callback, subscribeOnce == null ? false : subscribeOnce);
    }

    protected void removeSocketIoSubscription(@NonNull Subscription subscription, Identity identity) {
        if (subscription == null) {
            throw new NullPointerException("subscription is marked non-null but is null");
        }
        Identity identityToUse = identity == null ? this.identity : identity;
        this.socketIoManager.removeSocketIoSubscription(identityToUse, subscription);
    }

    @NonNull
    protected <TValue> URI addParameterToUrl(@NonNull URI url, @NonNull String parameterName, @NonNull TValue parameterValue) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (parameterValue == null) {
            throw new NullPointerException("parameterValue is marked non-null but is null");
        }
        String appendQuery = parameterName + "=" + parameterValue;
        Object newQuery = url.getQuery();
        newQuery = newQuery == null ? appendQuery : (String)newQuery + "&" + appendQuery;
        try {
            return new URI(url.getScheme(), url.getAuthority(), url.getPath(), (String)newQuery, url.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Uncaught", e);
        }
    }

    @NonNull
    private <TQuery> URI encodeQueryAndAddParametersToUrl(@NonNull URI url, @NonNull TQuery query) throws JsonProcessingException, URISyntaxException, UnsupportedEncodingException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        Map map = (Map)new ObjectMapper().convertValue(query, Map.class);
        for (Map.Entry param : map.entrySet()) {
            String encodedParameter;
            String paramName = param.getKey().toString();
            Object paramValue = param.getValue();
            if (paramValue == null) continue;
            if (paramValue.getClass().isArray()) {
                Object[] paramArray = (Object[])paramValue;
                CharSequence[] encodedParams = new String[paramArray.length];
                for (int i = 0; i < paramArray.length; ++i) {
                    encodedParams[i] = this.encodeValue(paramArray[i]);
                }
                encodedParameter = String.join((CharSequence)",", encodedParams);
            } else {
                encodedParameter = this.encodeValue(paramValue);
            }
            url = this.addParameterToUrl(url, paramName, encodedParameter);
        }
        return url;
    }

    @NonNull
    private <TValue> String encodeValue(@NonNull TValue value) throws JsonProcessingException, UnsupportedEncodingException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (value instanceof String || value instanceof Integer || value instanceof Boolean) {
            return this.encodeURIComponent(value);
        }
        if (value instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            sdf.setTimeZone(TimeZone.getTimeZone("CET"));
            return this.encodeURIComponent(sdf.format(value));
        }
        String stringifiedValue = new ObjectMapper().writeValueAsString(value);
        return this.encodeURIComponent(stringifiedValue);
    }

    @NonNull
    private <TValue> String encodeURIComponent(@NonNull TValue value) throws UnsupportedEncodingException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String component = value.toString();
        String result = URLEncoder.encode(component, "UTF-8");
        result = result.replace("+", "%20");
        result = this.revertEncode(result, '~');
        result = this.revertEncode(result, '\'');
        result = this.revertEncode(result, '(');
        result = this.revertEncode(result, ')');
        result = this.revertEncode(result, '!');
        return result;
    }

    @NonNull
    private String revertEncode(@NonNull String value, char character) throws UnsupportedEncodingException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String enc = URLEncoder.encode("" + character, "UTF-8");
        String result = value.replace(enc, "" + character);
        return result;
    }
}

