/*
 * Decompiled with CFR 0.152.
 */
package de.fiveminds.client;

import de.fiveminds.client.clients.ExternalTaskApiHttpClient;
import de.fiveminds.client.dataModels.externalTasks.ExternalTask;
import de.fiveminds.client.dataModels.externalTasks.ExternalTaskError;
import de.fiveminds.client.types.ExternalTaskWorkerConfig;
import de.fiveminds.client.types.HandleExternalTaskAction;
import de.fiveminds.client.types.WorkerErrorHandler;
import de.fiveminds.client.utility.AbortController;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;

public class ExternalTaskExecution<TExternalTaskPayload, TResultPayload>
implements AutoCloseable {
    @NonNull
    private ExternalTask<TExternalTaskPayload> externalTask;
    @NonNull
    private HandleExternalTaskAction<TExternalTaskPayload, TResultPayload> processingFunction;
    @NonNull
    private ExternalTaskApiHttpClient externalTaskClient;
    @NonNull
    private ExternalTaskWorkerConfig config;
    @NonNull
    private String topic;
    @NonNull
    private AbortController.AbortSignal abortSignal;
    private WorkerErrorHandler customErrorHandler;
    private ScheduledExecutorService interval;
    private Runnable abortSignalSubscription = () -> {};
    private CompletableFuture<Void> awaitAbortSignal;
    private Runnable abortSignalResolver = () -> {};
    private Logger logger;

    public ExternalTaskExecution(@NonNull ExternalTask<TExternalTaskPayload> externalTask, @NonNull HandleExternalTaskAction<TExternalTaskPayload, TResultPayload> processingFunction, @NonNull ExternalTaskApiHttpClient externalTaskClient, @NonNull ExternalTaskWorkerConfig config, @NonNull String topic, @NonNull AbortController.AbortSignal abortSignal, WorkerErrorHandler customErrorHandler) {
        if (externalTask == null) {
            throw new NullPointerException("externalTask is marked non-null but is null");
        }
        if (processingFunction == null) {
            throw new NullPointerException("processingFunction is marked non-null but is null");
        }
        if (externalTaskClient == null) {
            throw new NullPointerException("externalTaskClient is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        if (abortSignal == null) {
            throw new NullPointerException("abortSignal is marked non-null but is null");
        }
        this.externalTask = externalTask;
        this.processingFunction = processingFunction;
        this.externalTaskClient = externalTaskClient;
        this.config = config;
        this.topic = topic;
        this.abortSignal = abortSignal;
        this.customErrorHandler = customErrorHandler;
        this.logger = Logger.getLogger("external_task_execution");
    }

    public CompletableFuture<Void> execute() throws URISyntaxException, IOException, InterruptedException, ExecutionException {
        return CompletableFuture.runAsync(() -> {
            Object resultObject;
            if (this.abortSignal.isAborted()) {
                throw new RuntimeException(this.abortSignal.getException());
            }
            this.startAbortSignalSubscription();
            this.startExtendLockInterval();
            try {
                resultObject = CompletableFuture.anyOf(CompletableFuture.supplyAsync(() -> this.processingFunction.run(this.externalTask.getPayload(), this.externalTask, this.abortSignal)), this.awaitAbortSignal).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            if (this.abortSignal.isAborted()) {
                throw new RuntimeException(this.abortSignal.getException());
            }
            this.stopLockingInterval();
            if (resultObject != null) {
                try {
                    this.processResult(resultObject).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }).exceptionally(error -> {
            if (error instanceof RuntimeException) {
                if (error.getCause() != null) {
                    error = error.getCause();
                }
                this.handleError(WorkerErrorHandler.ErrorType.processExternalTask, (Exception)error);
                try {
                    this.handleExternalTaskExecutionError(error).get();
                }
                catch (IOException | InterruptedException | URISyntaxException | ExecutionException e) {
                    throw new RuntimeException("An unexpected exception occurred while handling an exception.", e);
                }
            }
            return null;
        });
    }

    private CompletableFuture<Void> processResult(Object result) {
        try {
            if (result instanceof ExternalTaskError) {
                this.handleExternalTaskExecutionError(result).get();
                return CompletableFuture.failedFuture((ExternalTaskError)result);
            }
            if (result instanceof Exception) {
                this.handleExternalTaskExecutionError(result).get();
                return CompletableFuture.failedFuture((Exception)result);
            }
            return this.externalTaskClient.finishExternalTask(this.config.workerId, this.externalTask.getId(), result, this.config.identity);
        }
        catch (Exception error) {
            this.handleError(WorkerErrorHandler.ErrorType.finishExternalTask, error);
            return CompletableFuture.failedFuture(error);
        }
    }

    private CompletableFuture<Void> handleExternalTaskExecutionError(final Object error) throws URISyntaxException, IOException, InterruptedException {
        ExternalTaskError workerError;
        if (this.abortSignal.isAborted()) {
            return CompletableFuture.failedFuture(this.abortSignal.getException());
        }
        this.logger.log(Level.SEVERE, "Error raised for external task " + this.externalTask.getId() + " with topic " + this.topic + ": ", new LogInfo(){
            public Object err;
            {
                this.err = error;
            }

            @Generated
            public Object getErr() {
                return this.err;
            }
        });
        if (error instanceof ExternalTaskError) {
            workerError = (ExternalTaskError)error;
        } else if (error instanceof Exception) {
            Exception typedError = (Exception)error;
            workerError = ExternalTaskError.builder().errorCode(typedError.getClass().getName()).errorMessage(typedError.getMessage()).errorDetails(typedError.getStackTrace()).build();
        } else {
            workerError = ExternalTaskError.builder().errorCode("ExternalTaskExecutionError").errorMessage("An error occurred while processing the external task.").errorDetails("No error details available.").build();
        }
        return this.externalTaskClient.handleError(this.config.workerId, this.externalTask.getId(), workerError, this.config.identity);
    }

    @Override
    public void close() {
        this.removeAbortSignalSubscription();
        this.stopLockingInterval();
    }

    private void stopLockingInterval() {
        if (this.interval != null) {
            this.interval.shutdown();
            this.interval = null;
        }
    }

    private void startAbortSignalSubscription() {
        this.awaitAbortSignal = new CompletableFuture();
        this.abortSignalResolver = () -> this.awaitAbortSignal.complete(null);
        this.abortSignalSubscription = () -> {
            if (this.abortSignalResolver != null) {
                this.abortSignalResolver.run();
            }
            this.close();
        };
        this.abortSignal.subscribe(this.abortSignalSubscription);
    }

    private void removeAbortSignalSubscription() {
        if (this.abortSignalSubscription != null) {
            this.abortSignal.unsubscribe(this.abortSignalSubscription);
        }
        if (this.abortSignalResolver != null) {
            this.abortSignalResolver.run();
        }
    }

    private void startExtendLockInterval() {
        int lockExtensionBuffer = 5000;
        this.interval = Executors.newSingleThreadScheduledExecutor();
        this.interval.scheduleAtFixedRate(() -> this.extendLocks(this.externalTask), 0L, this.config.lockDuration - 5000, TimeUnit.MILLISECONDS);
    }

    private CompletableFuture<Void> extendLocks(ExternalTask<TExternalTaskPayload> externalTask) {
        try {
            return this.externalTaskClient.extendLock(this.config.workerId, this.externalTask.getId(), this.config.lockDuration, this.config.identity);
        }
        catch (Exception error) {
            this.handleError(WorkerErrorHandler.ErrorType.extendLock, error);
            this.logger.log(Level.WARNING, "An error occurred while trying to extend the lock for ExternalTask " + this.externalTask.getId(), new LogInfo(){
                public Exception err;
                {
                    this.err = error;
                }

                @Generated
                public Exception getErr() {
                    return this.err;
                }
            });
            return CompletableFuture.failedFuture(error);
        }
    }

    private void handleError(WorkerErrorHandler.ErrorType errorType, Exception error) {
        if (this.customErrorHandler != null) {
            this.customErrorHandler.run(errorType, error, this.externalTask);
        }
    }

    private class LogInfo {
        public String workerId;
        public String externalTaskId;
        public String topic;

        @Generated
        public LogInfo() {
            this.workerId = ExternalTaskExecution.this.config.workerId;
            this.externalTaskId = ExternalTaskExecution.this.externalTask.getId();
            this.topic = ExternalTaskExecution.this.topic;
        }

        @Generated
        public String getWorkerId() {
            return this.workerId;
        }

        @Generated
        public String getExternalTaskId() {
            return this.externalTaskId;
        }

        @Generated
        public String getTopic() {
            return this.topic;
        }

        @Generated
        public void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Generated
        public void setExternalTaskId(String externalTaskId) {
            this.externalTaskId = externalTaskId;
        }

        @Generated
        public void setTopic(String topic) {
            this.topic = topic;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogInfo)) {
                return false;
            }
            LogInfo other = (LogInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$workerId = this.getWorkerId();
            String other$workerId = other.getWorkerId();
            if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
                return false;
            }
            String this$externalTaskId = this.getExternalTaskId();
            String other$externalTaskId = other.getExternalTaskId();
            if (this$externalTaskId == null ? other$externalTaskId != null : !this$externalTaskId.equals(other$externalTaskId)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            return !(this$topic == null ? other$topic != null : !this$topic.equals(other$topic));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LogInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $workerId = this.getWorkerId();
            result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
            String $externalTaskId = this.getExternalTaskId();
            result = result * 59 + ($externalTaskId == null ? 43 : $externalTaskId.hashCode());
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExternalTaskExecution.LogInfo(workerId=" + this.getWorkerId() + ", externalTaskId=" + this.getExternalTaskId() + ", topic=" + this.getTopic() + ")";
        }
    }
}

