package de.fiveminds.client.utility;

import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow.Subscriber;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class DynamicBodyPublisher implements BodyPublisher {
	private static final ObjectMapper objectMapper = new ObjectMapper();
	private final BodyPublisher stringPublisher;
	
	public DynamicBodyPublisher(Object objectToMap) {
		if (objectToMap == null) {
			stringPublisher = BodyPublishers.ofString("{}");
			return;
		}
		
		try {
			String mappedObject = objectMapper.writeValueAsString(objectToMap);
			System.out.println(mappedObject);
			stringPublisher = BodyPublishers.ofString(mappedObject);
		} catch (JsonProcessingException e) {
			throw new RuntimeException("Uncaught", e);
		}
	}
	
	@Override
	public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
		this.stringPublisher.subscribe(subscriber);
	}
	
	@Override
	public long contentLength() {
		return this.stringPublisher.contentLength();
	}
}
