package de.fiveminds.client.utility;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import lombok.Getter;

public class AbortController {
	private static Logger logger = Logger.getLogger("abort_controller");
	
	private Set<Runnable> callbacks = new HashSet<Runnable>();
	public final AbortSignal signal = new AbortSignal();
	
	public List<Exception> abort() {
		this.signal.aborted = true;
		
		List<Exception> exceptions = new ArrayList<Exception>();
		for (Runnable callback : callbacks) {
			try {
				callback.run();
			} catch (Exception e) {
				exceptions.add(e);
				logger.log(Level.SEVERE, "An error occurred while aborting.", e);
			}
		}
		
		return exceptions;
	}
	
	public class AbortSignal {
		@Getter private boolean aborted = false;
		
		public void subscribe(Runnable callback) {
			callbacks.add(callback);
		}

		public void unsubscribe(Runnable callback) {
			callbacks.remove(callback);
		}
		
		public InterruptedException getException() {
			return new InterruptedException("Execution has been aborted.");
		}

		public void throwIfAborted() throws InterruptedException {
			if (this.aborted) {
				throw this.getException();
			}
		}
	}
}
