package de.fiveminds.client.extensionAdapter;

import java.util.concurrent.CompletableFuture;

import de.fiveminds.client.dataModels.flowNodeInstance.FlowNodeInstance.FlowNodeInstanceSortSettings;
import de.fiveminds.client.dataModels.flowNodeInstance.Queries.UserTaskQuery;
import de.fiveminds.client.dataModels.flowNodeInstance.UserTaskInstance.UserTaskList;
import de.fiveminds.client.dataModels.flowNodeInstance.UserTaskInstance.UserTaskResult;
import de.fiveminds.client.dataModels.iam.Identity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

public interface IUserTaskExtensionAdapter {
	public CompletableFuture<UserTaskList> query(@NonNull UserTaskQuery query, UserTaskOptions options);
	
	public CompletableFuture<Void> reserveUserTaskInstance(@NonNull Identity identity, @NonNull String flowNodeInstanceId, @NonNull String actualOwnerId);

	public CompletableFuture<Void> cancelUserTaskInstanceReservation(@NonNull Identity identity, @NonNull String flowNodeInstanceId);
	
	public CompletableFuture<Void> finishUserTask(@NonNull String userTaskInstanceId, @NonNull UserTaskResult userTaskResult, Identity identity);
	
//  TODO: Fix SocketIoManager	
//	public Subscription onUserTaskWaiting(@NonNull Listener callback, CallbackOptions options) throws UnauthorizedError, URISyntaxException;
//	
//	public Subscription onUserTaskFinished(@NonNull Listener callback, CallbackOptions options) throws UnauthorizedError, URISyntaxException;
//	
//	public Subscription onUserTaskReserved(@NonNull Listener callback, CallbackOptions options) throws UnauthorizedError, URISyntaxException;
//	
//	public Subscription onUserTaskReservationCanceled(@NonNull Listener callback, CallbackOptions options) throws UnauthorizedError, URISyntaxException;
//
//	public void removeSubscription(@NonNull Subscription subscription, Identity identity);

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class UserTaskOptions {
		private Identity identity;
		
		private Integer offset;
		
		private Integer limit;
		
		private FlowNodeInstanceSortSettings sortSettings;
	}

	@Data
	@AllArgsConstructor
	@NoArgsConstructor
	@Builder
	public static class CallbackOptions {
		private Boolean subscribeOnce;
		
		private Identity identity;
	}
}
